/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.schema.opensearch;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.operate.conditions.OpensearchCondition;
import io.camunda.operate.exceptions.OperateRuntimeException;
import io.camunda.operate.property.OperateOpensearchProperties;
import io.camunda.operate.property.OperateProperties;
import io.camunda.operate.schema.IndexMapping;
import io.camunda.operate.schema.SchemaManager;
import io.camunda.operate.schema.indices.IndexDescriptor;
import io.camunda.operate.schema.templates.TemplateDescriptor;
import io.camunda.operate.store.opensearch.client.sync.RichOpenSearchClient;
import io.camunda.operate.util.LambdaExceptionUtil;
import jakarta.json.spi.JsonProvider;
import jakarta.json.stream.JsonParser;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.jsonb.JsonbJsonpMapper;
import org.opensearch.client.opensearch._types.OpenSearchException;
import org.opensearch.client.opensearch._types.Time;
import org.opensearch.client.opensearch._types.mapping.Property;
import org.opensearch.client.opensearch._types.mapping.TypeMapping;
import org.opensearch.client.opensearch.cluster.PutComponentTemplateRequest;
import org.opensearch.client.opensearch.indices.Alias;
import org.opensearch.client.opensearch.indices.CreateIndexRequest;
import org.opensearch.client.opensearch.indices.IndexSettings;
import org.opensearch.client.opensearch.indices.PutIndexTemplateRequest;
import org.opensearch.client.opensearch.indices.PutMappingRequest;
import org.opensearch.client.opensearch.indices.put_index_template.IndexTemplateMapping;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Component;
import org.springframework.util.StreamUtils;

@Component(value="schemaManager")
@Profile(value={"!test"})
@Conditional(value={OpensearchCondition.class})
public class OpensearchSchemaManager
implements SchemaManager {
    public static final String SETTINGS = "settings";
    public static final String MAPPINGS = "mappings";
    private static final String SCHEMA_OPENSEARCH_CREATE_POLICY_JSON = "/schema/opensearch/create/policy/%s.json";
    private static final Logger LOGGER = LoggerFactory.getLogger(OpensearchSchemaManager.class);
    protected final OperateProperties operateProperties;
    protected final RichOpenSearchClient richOpenSearchClient;
    private final ObjectMapper objectMapper;
    private final JsonbJsonpMapper jsonpMapper = new JsonbJsonpMapper();
    private final List<TemplateDescriptor> templateDescriptors;
    private final List<IndexDescriptor> indexDescriptors;

    @Autowired
    public OpensearchSchemaManager(OperateProperties operateProperties, RichOpenSearchClient richOpenSearchClient, List<TemplateDescriptor> templateDescriptors, List<IndexDescriptor> indexDescriptors, @Qualifier(value="operateObjectMapper") ObjectMapper objectMapper) {
        this.operateProperties = operateProperties;
        this.richOpenSearchClient = richOpenSearchClient;
        this.templateDescriptors = templateDescriptors;
        this.objectMapper = objectMapper;
        this.indexDescriptors = indexDescriptors.stream().filter(indexDescriptor -> !(indexDescriptor instanceof TemplateDescriptor)).toList();
    }

    @Override
    public void createSchema() {
        if (this.operateProperties.getArchiver().isIlmEnabled()) {
            this.createIsmPolicy();
        }
        this.createDefaults();
        this.createTemplates();
        this.createIndices();
    }

    @Override
    public void createDefaults() {
        OperateOpensearchProperties osConfig = this.operateProperties.getOpensearch();
        String settingsTemplateName = this.settingsTemplateName();
        LOGGER.info("Create default settings '{}' with {} shards and {} replicas per index.", new Object[]{settingsTemplateName, osConfig.getNumberOfShards(), osConfig.getNumberOfReplicas()});
        IndexSettings settings = this.getDefaultIndexSettings();
        this.richOpenSearchClient.template().createComponentTemplateWithRetries(new PutComponentTemplateRequest.Builder().name(settingsTemplateName).template(t -> t.settings(settings)).build());
    }

    @Override
    public void createIndex(IndexDescriptor indexDescriptor, String indexClasspathResource) {
        try {
            InputStream description = OpensearchSchemaManager.class.getResourceAsStream(indexClasspathResource);
            CreateIndexRequest request = this.createIndexFromJson(StreamUtils.copyToString((InputStream)description, (Charset)StandardCharsets.UTF_8), indexDescriptor.getFullQualifiedName(), Map.of(indexDescriptor.getAlias(), new Alias.Builder().isWriteIndex(Boolean.valueOf(false)).build()), this.getIndexSettings(indexDescriptor.getIndexName()));
            this.createIndex(request, indexDescriptor.getFullQualifiedName());
        }
        catch (Exception e) {
            throw new OperateRuntimeException("Could not create index " + indexDescriptor.getIndexName(), (Throwable)e);
        }
    }

    @Override
    public void createTemplate(TemplateDescriptor templateDescriptor, String templateClasspathResource) {
        String json = templateClasspathResource != null ? OpensearchSchemaManager.readTemplateJson(templateClasspathResource) : OpensearchSchemaManager.readTemplateJson(templateDescriptor.getSchemaClasspathFilename());
        PutIndexTemplateRequest indexTemplateRequest = this.prepareIndexTemplateRequest(templateDescriptor, json);
        this.putIndexTemplate(indexTemplateRequest);
        String indexName = templateDescriptor.getFullQualifiedName();
        CreateIndexRequest request = this.createIndexFromJson(json, templateDescriptor.getFullQualifiedName(), Map.of(templateDescriptor.getAlias(), new Alias.Builder().isWriteIndex(Boolean.valueOf(false)).build()), this.getIndexSettings(templateDescriptor.getIndexName()));
        this.createIndex(request, indexName);
    }

    @Override
    public boolean setIndexSettingsFor(Map<String, ?> settings, String indexPattern) {
        IndexSettings indexSettings = new IndexSettings.Builder().refreshInterval(ri -> ri.time((String)settings.get("index.refresh_interval"))).numberOfReplicas(String.valueOf(settings.get("index.number_of_replicas"))).build();
        return this.richOpenSearchClient.index().setIndexSettingsFor(indexSettings, indexPattern);
    }

    @Override
    public String getOrDefaultRefreshInterval(String indexName, String defaultValue) {
        return this.richOpenSearchClient.index().getOrDefaultRefreshInterval(indexName, defaultValue);
    }

    @Override
    public String getOrDefaultNumbersOfReplica(String indexName, String defaultValue) {
        return this.richOpenSearchClient.index().getOrDefaultNumbersOfReplica(indexName, defaultValue);
    }

    @Override
    public void refresh(String indexPattern) {
        this.richOpenSearchClient.index().refreshWithRetries(indexPattern);
    }

    @Override
    public boolean isHealthy() {
        if (this.operateProperties.getOpensearch().isHealthCheckEnabled()) {
            return this.richOpenSearchClient.cluster().isHealthy();
        }
        LOGGER.warn("OpenSearch cluster health check is disabled.");
        return true;
    }

    @Override
    public Set<String> getIndexNames(String indexPattern) {
        return this.richOpenSearchClient.index().getIndexNamesWithRetries(indexPattern);
    }

    @Override
    public Set<String> getAliasesNames(String indexPattern) {
        return this.richOpenSearchClient.index().getAliasesNamesWithRetries(indexPattern);
    }

    @Override
    public long getNumberOfDocumentsFor(String ... indexPatterns) {
        return this.richOpenSearchClient.index().getNumberOfDocumentsWithRetries(indexPatterns);
    }

    @Override
    public boolean deleteIndicesFor(String indexPattern) {
        return this.richOpenSearchClient.index().deleteIndicesWithRetries(indexPattern);
    }

    @Override
    public boolean deleteTemplatesFor(String deleteTemplatePattern) {
        return this.richOpenSearchClient.template().deleteTemplatesWithRetries(deleteTemplatePattern);
    }

    @Override
    public void removePipeline(String pipelineName) {
        this.richOpenSearchClient.pipeline().removePipelineWithRetries(pipelineName);
    }

    @Override
    public boolean addPipeline(String name, String pipelineDefinition) {
        return this.richOpenSearchClient.pipeline().addPipelineWithRetries(name, pipelineDefinition);
    }

    @Override
    public Map<String, String> getIndexSettingsFor(String indexName, String ... fields) {
        IndexSettings indexSettings = this.richOpenSearchClient.index().getIndexSettingsWithRetries(indexName);
        HashMap<String, String> result = new HashMap<String, String>();
        for (String field : fields) {
            if (field.equals("index.refresh_interval")) {
                Time refreshInterval = indexSettings.refreshInterval();
                result.put("index.refresh_interval", refreshInterval != null ? refreshInterval.time() : null);
            }
            if (!field.equals("index.number_of_replicas")) continue;
            result.put("index.number_of_replicas", indexSettings.numberOfReplicas());
        }
        return result;
    }

    @Override
    public String getIndexPrefix() {
        return this.operateProperties.getOpensearch().getIndexPrefix();
    }

    @Override
    public Map<String, IndexMapping> getIndexMappings(String indexNamePattern) {
        return this.richOpenSearchClient.index().getIndexMappings(indexNamePattern);
    }

    @Override
    public void updateSchema(Map<IndexDescriptor, Set<IndexMapping.IndexMappingProperty>> newFields) {
        for (Map.Entry<IndexDescriptor, Set<IndexMapping.IndexMappingProperty>> indexNewFields : newFields.entrySet()) {
            Map properties;
            if (indexNewFields.getKey() instanceof TemplateDescriptor) {
                LOGGER.info("Update template: " + ((TemplateDescriptor)indexNewFields.getKey()).getTemplateName());
                TemplateDescriptor templateDescriptor = (TemplateDescriptor)indexNewFields.getKey();
                String json = OpensearchSchemaManager.readTemplateJson(templateDescriptor.getSchemaClasspathFilename());
                PutIndexTemplateRequest indexTemplateRequest = this.prepareIndexTemplateRequest(templateDescriptor, json);
                this.putIndexTemplate(indexTemplateRequest, true);
            }
            try (JsonParser jsonParser = JsonProvider.provider().createParser((Reader)new StringReader(IndexMapping.IndexMappingProperty.toJsonString(indexNewFields.getValue(), this.objectMapper)));){
                properties = (Map)JsonpDeserializer.stringMapDeserializer((JsonpDeserializer)Property._DESERIALIZER).deserialize(jsonParser, (JsonpMapper)this.jsonpMapper);
            }
            PutMappingRequest request = new PutMappingRequest.Builder().index(indexNewFields.getKey().getAlias(), new String[0]).properties(properties).build();
            LOGGER.info(String.format("Index alias: %s. New fields will be added: %s", indexNewFields.getKey().getAlias(), indexNewFields.getValue()));
            this.richOpenSearchClient.index().putMapping(request);
        }
    }

    @Override
    public IndexMapping getExpectedIndexFields(IndexDescriptor indexDescriptor) {
        InputStream description = OpensearchSchemaManager.class.getResourceAsStream(indexDescriptor.getSchemaClasspathFilename());
        try {
            String currentVersionSchema = StreamUtils.copyToString((InputStream)description, (Charset)StandardCharsets.UTF_8);
            TypeReference<HashMap<String, Object>> type = new TypeReference<HashMap<String, Object>>(this){};
            Map mappings = (Map)((HashMap)this.objectMapper.readValue(currentVersionSchema, (TypeReference)type)).get(MAPPINGS);
            Map properties = (Map)mappings.get("properties");
            String dynamic = (String)mappings.get("dynamic");
            return new IndexMapping().setIndexName(indexDescriptor.getIndexName()).setDynamic(dynamic).setProperties(properties.entrySet().stream().map(LambdaExceptionUtil.rethrowFunction(entry -> new IndexMapping.IndexMappingProperty().setName((String)entry.getKey()).setTypeDefinition(entry.getValue()))).collect(Collectors.toSet()));
        }
        catch (IOException e) {
            throw new OperateRuntimeException((Throwable)e);
        }
    }

    private IndexSettings getDefaultIndexSettings() {
        OperateOpensearchProperties osConfig = this.operateProperties.getOpensearch();
        return new IndexSettings.Builder().numberOfShards(String.valueOf(osConfig.getNumberOfShards())).numberOfReplicas(String.valueOf(osConfig.getNumberOfReplicas())).build();
    }

    private IndexSettings getIndexSettings(String indexName) {
        OperateOpensearchProperties osConfig = this.operateProperties.getOpensearch();
        Integer shards = osConfig.getNumberOfShardsForIndices().getOrDefault(indexName, osConfig.getNumberOfShards());
        Integer replicas = osConfig.getNumberOfReplicasForIndices().getOrDefault(indexName, osConfig.getNumberOfReplicas());
        return new IndexSettings.Builder().numberOfShards(String.valueOf(shards)).numberOfReplicas(String.valueOf(replicas)).build();
    }

    private String settingsTemplateName() {
        OperateOpensearchProperties osConfig = this.operateProperties.getOpensearch();
        return String.format("%s_template", osConfig.getIndexPrefix());
    }

    private void createTemplates() {
        this.templateDescriptors.forEach(this::createTemplate);
    }

    private IndexSettings templateSettings(TemplateDescriptor indexDescriptor) {
        Integer shards = (Integer)this.operateProperties.getOpensearch().getNumberOfShardsForIndices().get(indexDescriptor.getIndexName());
        Integer replicas = (Integer)this.operateProperties.getOpensearch().getNumberOfReplicasForIndices().get(indexDescriptor.getIndexName());
        if (shards != null || replicas != null) {
            IndexSettings.Builder indexSettingsBuilder = new IndexSettings.Builder();
            if (shards != null) {
                indexSettingsBuilder.numberOfShards(shards.toString());
            }
            if (replicas != null) {
                indexSettingsBuilder.numberOfReplicas(replicas.toString());
            }
            return indexSettingsBuilder.build();
        }
        return null;
    }

    private void createTemplate(TemplateDescriptor templateDescriptor) {
        String json = OpensearchSchemaManager.readTemplateJson(templateDescriptor.getSchemaClasspathFilename());
        PutIndexTemplateRequest indexTemplateRequest = this.prepareIndexTemplateRequest(templateDescriptor, json);
        this.putIndexTemplate(indexTemplateRequest);
        String indexName = templateDescriptor.getFullQualifiedName();
        CreateIndexRequest request = this.createIndexFromJson(json, templateDescriptor.getFullQualifiedName(), Map.of(templateDescriptor.getAlias(), new Alias.Builder().isWriteIndex(Boolean.valueOf(false)).build()), this.getIndexSettings(templateDescriptor.getIndexName()));
        this.createIndex(request, indexName);
    }

    private static String readTemplateJson(String classPathResourceName) {
        try {
            InputStream description = OpensearchSchemaManager.class.getResourceAsStream(classPathResourceName);
            String json = StreamUtils.copyToString((InputStream)description, (Charset)StandardCharsets.UTF_8);
            return json;
        }
        catch (Exception e) {
            throw new OperateRuntimeException("Exception occurred when reading template JSON: " + e.getMessage(), (Throwable)e);
        }
    }

    private PutIndexTemplateRequest prepareIndexTemplateRequest(TemplateDescriptor templateDescriptor, String json) {
        IndexSettings templateSettings = this.templateSettings(templateDescriptor);
        IndexTemplateMapping.Builder templateBuilder = new IndexTemplateMapping.Builder().aliases(templateDescriptor.getAlias(), new Alias.Builder().build());
        try {
            JsonNode indexAsJSONNode = this.objectMapper.readTree((Reader)new StringReader(json));
            IndexSettings customSettings = this.getCustomSettings(templateSettings, indexAsJSONNode);
            TypeMapping mappings = this.getMappings(indexAsJSONNode.get(MAPPINGS));
            IndexTemplateMapping template = templateBuilder.mappings(mappings).settings(customSettings).build();
            PutIndexTemplateRequest request = new PutIndexTemplateRequest.Builder().name(templateDescriptor.getTemplateName()).indexPatterns(templateDescriptor.getIndexPattern(), new String[0]).template(template).composedOf(this.settingsTemplateName(), new String[0]).build();
            return request;
        }
        catch (Exception ex) {
            throw new OperateRuntimeException((Throwable)ex);
        }
    }

    private void putIndexTemplate(PutIndexTemplateRequest request) {
        this.putIndexTemplate(request, false);
    }

    private void putIndexTemplate(PutIndexTemplateRequest request, boolean overwrite) {
        boolean created = this.richOpenSearchClient.template().createTemplateWithRetries(request, overwrite);
        if (created) {
            LOGGER.debug("Template [{}] was successfully created", (Object)request.name());
        } else {
            LOGGER.debug("Template [{}] was NOT created", (Object)request.name());
        }
    }

    private void createIndex(CreateIndexRequest createIndexRequest, String indexName) {
        boolean created = this.richOpenSearchClient.index().createIndexWithRetries(createIndexRequest);
        if (created) {
            LOGGER.debug("Index [{}] was successfully created", (Object)indexName);
        } else {
            LOGGER.debug("Index [{}] was NOT created", (Object)indexName);
        }
    }

    private void createIndex(IndexDescriptor indexDescriptor) {
        this.createIndex(indexDescriptor, indexDescriptor.getSchemaClasspathFilename());
    }

    private CreateIndexRequest createIndexFromJson(String json, String indexName, Map<String, Alias> aliases, IndexSettings settings) {
        try {
            JsonNode indexAsJSONNode = this.objectMapper.readTree((Reader)new StringReader(json));
            IndexSettings customSettings = this.getCustomSettings(settings, indexAsJSONNode);
            TypeMapping mappings = this.getMappings(indexAsJSONNode.get(MAPPINGS));
            return new CreateIndexRequest.Builder().index(indexName).aliases(aliases).settings(customSettings).mappings(mappings).build();
        }
        catch (Exception e) {
            throw new OperateRuntimeException("Could not load schema for " + indexName, (Throwable)e);
        }
    }

    private TypeMapping getMappings(JsonNode mappingsAsJSON) {
        JsonParser jsonParser = JsonProvider.provider().createParser((Reader)new StringReader(mappingsAsJSON.toPrettyString()));
        return (TypeMapping)TypeMapping._DESERIALIZER.deserialize(jsonParser, (JsonpMapper)this.jsonpMapper);
    }

    private IndexSettings getCustomSettings(IndexSettings defaultSettings, JsonNode indexAsJSONNode) {
        if (indexAsJSONNode.has(SETTINGS)) {
            JsonNode settingsJSON = indexAsJSONNode.get(SETTINGS);
            JsonParser jsonParser = JsonProvider.provider().createParser((Reader)new StringReader(settingsJSON.toPrettyString()));
            IndexSettings updatedSettings = (IndexSettings)IndexSettings._DESERIALIZER.deserialize(jsonParser, (JsonpMapper)this.jsonpMapper);
            return new IndexSettings.Builder().index(defaultSettings).analysis(updatedSettings.analysis()).build();
        }
        return defaultSettings;
    }

    private void createIndices() {
        this.indexDescriptors.forEach(this::createIndex);
    }

    private Optional<Map<String, Object>> fetchIsmPolicy() {
        try {
            return Optional.ofNullable(this.richOpenSearchClient.ism().getPolicy("operate_delete_archived_indices"));
        }
        catch (OpenSearchException e) {
            if (e.status() != 404) {
                LOGGER.error(String.format("Failed to get policy %s", "operate_delete_archived_indices"), (Throwable)e);
            }
            return Optional.empty();
        }
    }

    private String loadIsmPolicy() throws IOException {
        String policyFilename = String.format(SCHEMA_OPENSEARCH_CREATE_POLICY_JSON, "operate_delete_archived_indices");
        InputStream inputStream = OpensearchSchemaManager.class.getResourceAsStream(policyFilename);
        String policyContent = StreamUtils.copyToString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
        return policyContent.replace("$MIN_INDEX_AGE", this.operateProperties.getArchiver().getIlmMinAgeForDeleteArchivedIndices());
    }

    private void createIsmPolicy() {
        this.fetchIsmPolicy().ifPresentOrElse(ismPolicy -> LOGGER.warn("ISM policy {} already exists: {}.", (Object)"operate_delete_archived_indices", ismPolicy), () -> {
            try {
                this.richOpenSearchClient.ism().createPolicy("operate_delete_archived_indices", this.loadIsmPolicy());
                LOGGER.info("Created ISM policy {} for min age of {}.", (Object)"operate_delete_archived_indices", (Object)this.operateProperties.getArchiver().getIlmMinAgeForDeleteArchivedIndices());
            }
            catch (Exception e) {
                throw new OperateRuntimeException("Failed to create ISM policy operate_delete_archived_indices", (Throwable)e);
            }
        });
    }
}

