/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.schema.opensearch;

import io.camunda.operate.exceptions.MigrationException;
import io.camunda.operate.property.MigrationProperties;
import io.camunda.operate.schema.SchemaManager;
import io.camunda.operate.schema.migration.ReindexWithQueryAndScriptPlan;
import io.camunda.operate.schema.migration.Step;
import io.camunda.operate.store.opensearch.client.sync.RichOpenSearchClient;
import io.camunda.operate.store.opensearch.dsl.QueryDSL;
import io.camunda.operate.store.opensearch.dsl.RequestDSL;
import io.camunda.operate.util.LambdaExceptionUtil;
import io.camunda.operate.util.Tuple;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.opensearch.client.json.JsonData;
import org.opensearch.client.opensearch._types.InlineScript;
import org.opensearch.client.opensearch._types.Script;
import org.opensearch.client.opensearch._types.SortOptions;
import org.opensearch.client.opensearch._types.SortOrder;
import org.opensearch.client.opensearch.core.ReindexRequest;
import org.opensearch.client.opensearch.core.SearchRequest;
import org.opensearch.client.opensearch.core.reindex.Destination;
import org.opensearch.client.opensearch.core.reindex.Source;
import org.opensearch.client.opensearch.core.search.Hit;
import org.opensearch.client.util.ObjectBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpensearchReindexWithQueryAndScriptPlan
implements ReindexWithQueryAndScriptPlan {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpensearchReindexWithQueryAndScriptPlan.class);
    private final MigrationProperties migrationProperties;
    private final RichOpenSearchClient richOpenSearchClient;
    private List<Step> steps = List.of();
    private String srcIndex;
    private String dstIndex;
    private String listViewIndexName;

    public OpensearchReindexWithQueryAndScriptPlan(RichOpenSearchClient richOpenSearchClient, MigrationProperties migrationProperties) {
        this.richOpenSearchClient = richOpenSearchClient;
        this.migrationProperties = migrationProperties;
    }

    @Override
    public ReindexWithQueryAndScriptPlan setSrcIndex(String srcIndex) {
        this.srcIndex = srcIndex;
        return this;
    }

    @Override
    public ReindexWithQueryAndScriptPlan setDstIndex(String dstIndex) {
        this.dstIndex = dstIndex;
        return this;
    }

    @Override
    public ReindexWithQueryAndScriptPlan setSteps(List<Step> steps) {
        this.steps = steps;
        return this;
    }

    @Override
    public ReindexWithQueryAndScriptPlan setListViewIndexName(String listViewIndexName) {
        this.listViewIndexName = listViewIndexName;
        return this;
    }

    private Script buildScript(String scriptContent, Map<String, Tuple<String, String>> bpmnProcessIdsMap) {
        Map<String, JsonData> paramsMap = Map.of("dstIndex", JsonData.of((Object)this.dstIndex), "bpmnProcessIds", JsonData.of(bpmnProcessIdsMap));
        return (Script)new Script.Builder().inline(InlineScript.of(s -> (ObjectBuilder)s.lang("painless").source(scriptContent).params(paramsMap))).build();
    }

    private Map<String, Tuple<String, String>> getBpmnProcessIds(Set<Long> processInstanceKeys) {
        SearchRequest.Builder request = RequestDSL.searchRequestBuilder(this.listViewIndexName + "*").query(QueryDSL.longTerms("key", processInstanceKeys)).source(QueryDSL.sourceInclude("key", "bpmnProcessId", "processDefinitionKey")).size(Integer.valueOf(this.migrationProperties.getScriptParamsCount()));
        HashMap<String, Tuple<String, String>> results = new HashMap<String, Tuple<String, String>>();
        record Result(String key, String bpmnProcessId, String processKey) {
        }
        this.richOpenSearchClient.doc().scrollWith(request, Result.class, hits -> hits.forEach(hit -> {
            Result source = (Result)hit.source();
            if (source != null) {
                results.put(source.key(), new Tuple((Object)source.bpmnProcessId(), (Object)source.processKey()));
            }
        }));
        return results;
    }

    @Override
    public List<Step> getSteps() {
        return this.steps;
    }

    @Override
    public void executeOn(SchemaManager schemaManager) throws MigrationException {
        String processInstanceKeyField = "processInstanceKey";
        SearchRequest.Builder searchRequest = RequestDSL.searchRequestBuilder(this.srcIndex + "_*").source(QueryDSL.sourceInclude("processInstanceKey")).sort(QueryDSL.sortOptions("processInstanceKey", SortOrder.Asc), new SortOptions[0]).size(Integer.valueOf(this.migrationProperties.getScriptParamsCount()));
        HashSet<Long> processInstanceKeys = new HashSet<Long>();
        try {
            this.richOpenSearchClient.doc().scrollWith(searchRequest, Long.class, LambdaExceptionUtil.rethrowConsumer(hits -> {
                Set currentProcessInstanceKeys = hits.stream().map(Hit::source).collect(Collectors.toSet());
                if (processInstanceKeys.size() + currentProcessInstanceKeys.size() >= this.migrationProperties.getScriptParamsCount()) {
                    int remainingSize = this.migrationProperties.getScriptParamsCount() - processInstanceKeys.size();
                    Set subSet = currentProcessInstanceKeys.stream().limit(remainingSize).collect(Collectors.toSet());
                    currentProcessInstanceKeys.removeAll(subSet);
                    processInstanceKeys.addAll(subSet);
                    this.reindexPart(processInstanceKeys);
                    processInstanceKeys.clear();
                    processInstanceKeys.addAll(currentProcessInstanceKeys);
                } else {
                    processInstanceKeys.addAll(currentProcessInstanceKeys);
                }
            }));
            if (!processInstanceKeys.isEmpty()) {
                this.reindexPart(processInstanceKeys);
            }
        }
        catch (Exception e) {
            throw new MigrationException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void validateMigrationResults(SchemaManager schemaManager) throws MigrationException {
        long srcCount = schemaManager.getNumberOfDocumentsFor(this.srcIndex + "_*");
        long dstCount = schemaManager.getNumberOfDocumentsFor(this.dstIndex + "_*");
        if (srcCount != dstCount) {
            throw new MigrationException(String.format("Exception occurred when migrating %s. Number of documents in source indices: %s, number of documents in destination indices: %s", this.srcIndex, srcCount, dstCount));
        }
    }

    private void reindexPart(Set<Long> processInstanceKeys) {
        Map<String, Tuple<String, String>> bpmnProcessIdsMap = this.getBpmnProcessIds(processInstanceKeys);
        LOGGER.debug("Migrate srcIndex: {}, processInstanceKeys: {}, bpmnProcessIdsMap: {}", new Object[]{this.srcIndex, processInstanceKeys, bpmnProcessIdsMap});
        String content = this.steps.get(0).getContent();
        ReindexRequest.Builder reindexRequest = new ReindexRequest.Builder().source(Source.of(b -> b.index(this.srcIndex, new String[0]).query(QueryDSL.longTerms("processInstanceKey", processInstanceKeys)).size(Integer.valueOf(this.migrationProperties.getReindexBatchSize())))).dest(Destination.of(b -> b.index(this.dstIndex + "_"))).script(this.buildScript("ctx._index = params.dstIndex+'_' + (ctx._index.substring(ctx._index.indexOf('_') + 1, ctx._index.length()));" + content, bpmnProcessIdsMap));
        if (this.migrationProperties.getSlices() > 0) {
            reindexRequest.slices(Long.valueOf(this.migrationProperties.getSlices()));
        }
        this.richOpenSearchClient.index().reindexWithRetries(reindexRequest.build(), false);
    }

    public String toString() {
        return "OpensearchReindexWithQueryAndScriptPlan [steps=" + String.valueOf(this.steps) + ",  srcIndex=" + this.srcIndex + ", dstIndex=" + this.dstIndex + "]";
    }
}

