/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.schema.migration.elasticsearch;

import io.camunda.operate.exceptions.MigrationException;
import io.camunda.operate.property.MigrationProperties;
import io.camunda.operate.schema.SchemaManager;
import io.camunda.operate.schema.migration.PipelineReindexPlan;
import io.camunda.operate.schema.migration.ReindexPlan;
import io.camunda.operate.schema.migration.Step;
import io.camunda.operate.store.elasticsearch.RetryElasticsearchClient;
import io.camunda.operate.util.CollectionUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.elasticsearch.index.reindex.ReindexRequest;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptType;

public class ElasticsearchPipelineReindexPlan
extends PipelineReindexPlan
implements ReindexPlan {
    private final RetryElasticsearchClient retryElasticsearchClient;
    private final MigrationProperties migrationProperties;
    private Script script;

    public ElasticsearchPipelineReindexPlan(RetryElasticsearchClient retryElasticsearchClient, MigrationProperties migrationProperties) {
        this.retryElasticsearchClient = retryElasticsearchClient;
        this.migrationProperties = migrationProperties;
    }

    public void buildScript(String scriptContent, Map<String, Object> params) {
        this.script = new Script(ScriptType.INLINE, "painless", scriptContent, params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeOn(SchemaManager schemaManager) throws MigrationException {
        Optional<String> pipelineName = this.createPipelineFromSteps(schemaManager);
        ReindexRequest reindexRequest = ((ReindexRequest)new ReindexRequest().setSourceIndices(new String[]{this.srcIndex + "_*"}).setDestIndex(this.dstIndex + "_").setSlices(this.migrationProperties.getSlices())).setSourceBatchSize(this.migrationProperties.getReindexBatchSize());
        pipelineName.ifPresent(arg_0 -> ((ReindexRequest)reindexRequest).setDestPipeline(arg_0));
        if (this.script == null) {
            this.buildScript("ctx._index = params.dstIndex+'_' + (ctx._index.substring(ctx._index.indexOf('_') + 1, ctx._index.length()));", Map.of("dstIndex", this.dstIndex));
        }
        reindexRequest.setScript(this.script);
        try {
            this.retryElasticsearchClient.reindex(reindexRequest);
        }
        finally {
            pipelineName.ifPresent(schemaManager::removePipeline);
        }
    }

    @Override
    public String getPipelineDefinition() {
        List stepsAsJSON = CollectionUtil.map((Collection)this.steps, Step::getContent);
        return "{ \"processors\": [" + String.join((CharSequence)", ", stepsAsJSON) + "] }";
    }

    public String toString() {
        return "ElasticsearchReindexPlan [steps=" + String.valueOf(this.steps) + ",  srcIndex=" + this.srcIndex + ", dstIndex=" + this.dstIndex + "]";
    }
}

