/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.schema.migration;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.camunda.operate.schema.migration.FillPostImporterQueueStep;
import io.camunda.operate.schema.migration.ProcessorStep;
import io.camunda.operate.schema.migration.SemanticVersion;
import io.camunda.operate.schema.migration.SetBpmnProcessIdStep;
import java.time.OffsetDateTime;
import java.util.Comparator;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME)
@JsonSubTypes(value={@JsonSubTypes.Type(value=ProcessorStep.class), @JsonSubTypes.Type(value=SetBpmnProcessIdStep.class), @JsonSubTypes.Type(value=FillPostImporterQueueStep.class)})
public interface Step {
    public static final String INDEX_NAME = "indexName";
    public static final String CREATED_DATE = "createdDate";
    public static final String APPLIED = "applied";
    public static final String APPLIED_DATE = "appliedDate";
    public static final String VERSION = "version";
    public static final String ORDER = "order";
    public static final String CONTENT = "content";
    public static final Comparator<Step> SEMANTICVERSION_COMPARATOR = new Comparator<Step>(){

        @Override
        public int compare(Step s1, Step s2) {
            return SemanticVersion.fromVersion(s1.getVersion()).compareTo(SemanticVersion.fromVersion(s2.getVersion()));
        }
    };
    public static final Comparator<Step> ORDER_COMPARATOR = new Comparator<Step>(){

        @Override
        public int compare(Step s1, Step s2) {
            return s1.getOrder().compareTo(s2.getOrder());
        }
    };
    public static final Comparator<Step> SEMANTICVERSION_ORDER_COMPARATOR = new Comparator<Step>(){

        @Override
        public int compare(Step s1, Step s2) {
            int result = SEMANTICVERSION_COMPARATOR.compare(s1, s2);
            if (result == 0) {
                result = ORDER_COMPARATOR.compare(s1, s2);
            }
            return result;
        }
    };

    public OffsetDateTime getCreatedDate();

    public Step setCreatedDate(OffsetDateTime var1);

    public OffsetDateTime getAppliedDate();

    public Step setAppliedDate(OffsetDateTime var1);

    public String getVersion();

    public Integer getOrder();

    public boolean isApplied();

    public Step setApplied(boolean var1);

    public String getIndexName();

    public String getContent();

    public String getDescription();
}

