/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.schema.migration;

import io.camunda.operate.exceptions.MigrationException;
import io.camunda.operate.schema.migration.Step;
import io.camunda.operate.schema.migration.StepsRepository;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseStepsRepository
implements StepsRepository {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public void updateSteps() throws IOException, MigrationException {
        List<Step> stepsFromFiles = this.readStepsFromClasspath();
        List<Step> stepsFromRepository = this.findAll();
        for (Step step : stepsFromFiles) {
            if (stepsFromRepository.contains(step)) continue;
            step.setCreatedDate(OffsetDateTime.now());
            this.logger.info("Add new step {} to repository.", (Object)step);
            this.save(step);
        }
        this.refreshIndex();
    }
}

