/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.schema.elasticsearch;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.operate.conditions.ElasticsearchCondition;
import io.camunda.operate.exceptions.OperateRuntimeException;
import io.camunda.operate.property.OperateElasticsearchProperties;
import io.camunda.operate.property.OperateProperties;
import io.camunda.operate.schema.IndexMapping;
import io.camunda.operate.schema.SchemaManager;
import io.camunda.operate.schema.indices.AbstractIndexDescriptor;
import io.camunda.operate.schema.indices.IndexDescriptor;
import io.camunda.operate.schema.templates.TemplateDescriptor;
import io.camunda.operate.store.elasticsearch.RetryElasticsearchClient;
import io.camunda.operate.util.ElasticsearchJSONUtil;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.elasticsearch.action.admin.indices.alias.Alias;
import org.elasticsearch.client.indexlifecycle.DeleteAction;
import org.elasticsearch.client.indexlifecycle.LifecyclePolicy;
import org.elasticsearch.client.indexlifecycle.Phase;
import org.elasticsearch.client.indexlifecycle.PutLifecyclePolicyRequest;
import org.elasticsearch.client.indices.CreateIndexRequest;
import org.elasticsearch.client.indices.PutComponentTemplateRequest;
import org.elasticsearch.client.indices.PutComposableIndexTemplateRequest;
import org.elasticsearch.client.indices.PutIndexTemplateRequest;
import org.elasticsearch.client.indices.PutMappingRequest;
import org.elasticsearch.cluster.metadata.AliasMetadata;
import org.elasticsearch.cluster.metadata.ComponentTemplate;
import org.elasticsearch.cluster.metadata.ComposableIndexTemplate;
import org.elasticsearch.cluster.metadata.Template;
import org.elasticsearch.common.compress.CompressedXContent;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xcontent.XContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Component;
import org.springframework.util.StreamUtils;

@Conditional(value={ElasticsearchCondition.class})
@Component(value="schemaManager")
@Profile(value={"!test"})
public class ElasticsearchSchemaManager
implements SchemaManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ElasticsearchSchemaManager.class);
    private static final String NUMBER_OF_SHARDS = "index.number_of_shards";
    private static final String NUMBER_OF_REPLICAS = "index.number_of_replicas";
    @Autowired
    protected RetryElasticsearchClient retryElasticsearchClient;
    @Autowired
    protected OperateProperties operateProperties;
    @Autowired
    private List<AbstractIndexDescriptor> indexDescriptors;
    @Autowired
    private List<TemplateDescriptor> templateDescriptors;
    @Autowired
    @Qualifier(value="operateObjectMapper")
    private ObjectMapper objectMapper;

    @Override
    public void createSchema() {
        if (this.operateProperties.getArchiver().isIlmEnabled()) {
            this.createIndexLifeCycles();
        }
        this.createDefaults();
        this.createTemplates();
        this.createIndices();
    }

    @Override
    public void createDefaults() {
        OperateElasticsearchProperties elsConfig = this.operateProperties.getElasticsearch();
        String settingsTemplate = this.settingsTemplateName();
        LOGGER.info("Create default settings from '{}' with {} shards and {} replicas per index.", new Object[]{settingsTemplate, elsConfig.getNumberOfShards(), elsConfig.getNumberOfReplicas()});
        Settings settings = this.getDefaultIndexSettings();
        Template template = new Template(settings, null, null);
        ComponentTemplate componentTemplate = new ComponentTemplate(template, null, null);
        PutComponentTemplateRequest request = new PutComponentTemplateRequest().name(settingsTemplate).componentTemplate(componentTemplate);
        this.retryElasticsearchClient.createComponentTemplate(request);
    }

    @Override
    public void createIndex(IndexDescriptor indexDescriptor, String indexClasspathResource) {
        Map indexDescription = ElasticsearchJSONUtil.readJSONFileToMap((String)indexClasspathResource);
        this.createIndex(new CreateIndexRequest(indexDescriptor.getFullQualifiedName()).source(indexDescription).aliases(Set.of(new Alias(indexDescriptor.getAlias()).writeIndex(Boolean.valueOf(false)))).settings(this.getIndexSettings(indexDescriptor.getIndexName())), indexDescriptor.getFullQualifiedName());
    }

    @Override
    public void createTemplate(TemplateDescriptor templateDescriptor, String templateClasspathResource) {
        PutComposableIndexTemplateRequest request = this.prepareComposableTemplateRequest(templateDescriptor, templateClasspathResource);
        this.putIndexTemplate(request);
        String indexName = templateDescriptor.getFullQualifiedName();
        CreateIndexRequest createIndexRequest = new CreateIndexRequest(indexName).aliases(Set.of(new Alias(templateDescriptor.getAlias()).writeIndex(Boolean.valueOf(false)))).settings(this.getIndexSettings(templateDescriptor.getIndexName()));
        this.createIndex(createIndexRequest, indexName);
    }

    @Override
    public boolean setIndexSettingsFor(Map<String, ?> settings, String indexPattern) {
        return this.retryElasticsearchClient.setIndexSettingsFor(Settings.builder().loadFromMap(settings).build(), indexPattern);
    }

    @Override
    public String getOrDefaultRefreshInterval(String indexName, String defaultValue) {
        return this.retryElasticsearchClient.getOrDefaultRefreshInterval(indexName, defaultValue);
    }

    @Override
    public String getOrDefaultNumbersOfReplica(String indexName, String defaultValue) {
        return this.retryElasticsearchClient.getOrDefaultNumbersOfReplica(indexName, defaultValue);
    }

    @Override
    public void refresh(String indexPattern) {
        this.retryElasticsearchClient.refresh(indexPattern);
    }

    @Override
    public boolean isHealthy() {
        if (this.operateProperties.getElasticsearch().isHealthCheckEnabled()) {
            return this.retryElasticsearchClient.isHealthy();
        }
        LOGGER.warn("Elasticsearch cluster health check is disabled.");
        return true;
    }

    @Override
    public Set<String> getIndexNames(String indexPattern) {
        return this.retryElasticsearchClient.getIndexNames(indexPattern);
    }

    @Override
    public Set<String> getAliasesNames(String indexPattern) {
        return this.retryElasticsearchClient.getAliasesNames(indexPattern);
    }

    @Override
    public long getNumberOfDocumentsFor(String ... indexPatterns) {
        return this.retryElasticsearchClient.getNumberOfDocumentsFor(indexPatterns);
    }

    @Override
    public boolean deleteIndicesFor(String indexPattern) {
        return this.retryElasticsearchClient.deleteIndicesFor(indexPattern);
    }

    @Override
    public boolean deleteTemplatesFor(String deleteTemplatePattern) {
        return this.retryElasticsearchClient.deleteTemplatesFor(deleteTemplatePattern);
    }

    @Override
    public void removePipeline(String pipelineName) {
        this.retryElasticsearchClient.removePipeline(pipelineName);
    }

    @Override
    public boolean addPipeline(String name, String pipelineDefinition) {
        return this.retryElasticsearchClient.addPipeline(name, pipelineDefinition);
    }

    @Override
    public Map<String, String> getIndexSettingsFor(String indexName, String ... fields) {
        return this.retryElasticsearchClient.getIndexSettingsFor(indexName, fields);
    }

    @Override
    public String getIndexPrefix() {
        return this.operateProperties.getElasticsearch().getIndexPrefix();
    }

    @Override
    public Map<String, IndexMapping> getIndexMappings(String indexName) {
        return this.retryElasticsearchClient.getIndexMappings(indexName);
    }

    @Override
    public void updateSchema(Map<IndexDescriptor, Set<IndexMapping.IndexMappingProperty>> newFields) {
        for (Map.Entry<IndexDescriptor, Set<IndexMapping.IndexMappingProperty>> indexNewFields : newFields.entrySet()) {
            if (indexNewFields.getKey() instanceof TemplateDescriptor) {
                LOGGER.info("Update template: " + ((TemplateDescriptor)indexNewFields.getKey()).getTemplateName());
                TemplateDescriptor templateDescriptor = (TemplateDescriptor)indexNewFields.getKey();
                PutComposableIndexTemplateRequest request = this.prepareComposableTemplateRequest(templateDescriptor, null);
                this.putIndexTemplate(request, true);
            }
            PutMappingRequest request = new PutMappingRequest(new String[]{indexNewFields.getKey().getAlias()});
            request.source("{\"properties\":" + IndexMapping.IndexMappingProperty.toJsonString(indexNewFields.getValue(), this.objectMapper) + "}", XContentType.JSON);
            LOGGER.info(String.format("Index alias: %s. New fields will be added: %s", indexNewFields.getKey().getAlias(), indexNewFields.getValue()));
            this.retryElasticsearchClient.putMapping(request);
        }
    }

    @Override
    public IndexMapping getExpectedIndexFields(IndexDescriptor indexDescriptor) {
        InputStream description = ElasticsearchSchemaManager.class.getResourceAsStream(indexDescriptor.getSchemaClasspathFilename());
        try {
            String currentVersionSchema = StreamUtils.copyToString((InputStream)description, (Charset)StandardCharsets.UTF_8);
            TypeReference<HashMap<String, Object>> type = new TypeReference<HashMap<String, Object>>(this){};
            Map mappings = (Map)((HashMap)this.objectMapper.readValue(currentVersionSchema, (TypeReference)type)).get("mappings");
            Map properties = (Map)mappings.get("properties");
            String dynamic = (String)mappings.get("dynamic");
            return new IndexMapping().setIndexName(indexDescriptor.getIndexName()).setDynamic(dynamic).setProperties(properties.entrySet().stream().map(entry -> new IndexMapping.IndexMappingProperty().setName((String)entry.getKey()).setTypeDefinition(entry.getValue())).collect(Collectors.toSet()));
        }
        catch (IOException e) {
            throw new OperateRuntimeException((Throwable)e);
        }
    }

    private String settingsTemplateName() {
        OperateElasticsearchProperties elsConfig = this.operateProperties.getElasticsearch();
        return String.format("%s_template", elsConfig.getIndexPrefix());
    }

    private Settings getDefaultIndexSettings() {
        OperateElasticsearchProperties elsConfig = this.operateProperties.getElasticsearch();
        return Settings.builder().put(NUMBER_OF_SHARDS, elsConfig.getNumberOfShards()).put(NUMBER_OF_REPLICAS, elsConfig.getNumberOfReplicas()).build();
    }

    private Settings getIndexSettings(String indexName) {
        OperateElasticsearchProperties elsConfig = this.operateProperties.getElasticsearch();
        Integer shards = elsConfig.getNumberOfShardsForIndices().getOrDefault(indexName, elsConfig.getNumberOfShards());
        Integer replicas = elsConfig.getNumberOfReplicasForIndices().getOrDefault(indexName, elsConfig.getNumberOfReplicas());
        return Settings.builder().put(NUMBER_OF_SHARDS, shards.intValue()).put(NUMBER_OF_REPLICAS, replicas.intValue()).build();
    }

    private void createIndexLifeCycles() {
        TimeValue timeValue = TimeValue.parseTimeValue((String)this.operateProperties.getArchiver().getIlmMinAgeForDeleteArchivedIndices(), (String)"IndexLifeCycle index.lifecycle.name");
        LOGGER.info("Create Index Lifecycle {} for min age of {} ", (Object)"operate_delete_archived_indices", (Object)timeValue.getStringRep());
        HashMap<String, Phase> phases = new HashMap<String, Phase>();
        Map<String, DeleteAction> deleteActions = Collections.singletonMap("delete", new DeleteAction());
        phases.put("delete", new Phase("delete", timeValue, deleteActions));
        LifecyclePolicy policy = new LifecyclePolicy("operate_delete_archived_indices", phases);
        PutLifecyclePolicyRequest request = new PutLifecyclePolicyRequest(policy);
        this.retryElasticsearchClient.putLifeCyclePolicy(request);
    }

    private void createIndices() {
        this.indexDescriptors.forEach(this::createIndex);
    }

    private void createTemplates() {
        this.templateDescriptors.forEach(this::createTemplate);
    }

    private void createIndex(IndexDescriptor indexDescriptor) {
        this.createIndex(indexDescriptor, indexDescriptor.getSchemaClasspathFilename());
    }

    private void createTemplate(TemplateDescriptor templateDescriptor) {
        this.createTemplate(templateDescriptor, null);
    }

    private PutComposableIndexTemplateRequest prepareComposableTemplateRequest(TemplateDescriptor templateDescriptor, String templateClasspathResource) {
        String templateResourceName = templateClasspathResource != null ? templateClasspathResource : templateDescriptor.getSchemaClasspathFilename();
        Template template = this.getTemplateFrom(templateDescriptor, templateResourceName);
        ComposableIndexTemplate composableTemplate = new ComposableIndexTemplate.Builder().indexPatterns(List.of(templateDescriptor.getIndexPattern())).template(template).componentTemplates(List.of(this.settingsTemplateName())).build();
        PutComposableIndexTemplateRequest request = new PutComposableIndexTemplateRequest().name(templateDescriptor.getTemplateName()).indexTemplate(composableTemplate);
        return request;
    }

    private void overrideTemplateSettings(Map<String, Object> templateConfig, TemplateDescriptor templateDescriptor) {
        Settings indexSettings = this.getIndexSettings(templateDescriptor.getIndexName());
        Map settings = templateConfig.getOrDefault("settings", new HashMap());
        Map index = settings.getOrDefault("index", new HashMap());
        index.put("number_of_shards", indexSettings.get(NUMBER_OF_SHARDS));
        index.put("number_of_replicas", indexSettings.get(NUMBER_OF_REPLICAS));
        settings.put("index", index);
        templateConfig.put("settings", settings);
    }

    private Template getTemplateFrom(TemplateDescriptor templateDescriptor, String templateFilename) {
        Map templateConfig = ElasticsearchJSONUtil.readJSONFileToMap((String)templateFilename);
        this.overrideTemplateSettings(templateConfig, templateDescriptor);
        PutIndexTemplateRequest ptr = new PutIndexTemplateRequest(templateDescriptor.getTemplateName()).source(templateConfig);
        try {
            Map<String, AliasMetadata> aliases = Map.of(templateDescriptor.getAlias(), AliasMetadata.builder((String)templateDescriptor.getAlias()).build());
            return new Template(ptr.settings(), new CompressedXContent(ptr.mappings()), aliases);
        }
        catch (IOException e) {
            throw new OperateRuntimeException(String.format("Error in reading mappings for %s ", templateDescriptor.getTemplateName()), (Throwable)e);
        }
    }

    private void createIndex(CreateIndexRequest createIndexRequest, String indexName) {
        boolean created = this.retryElasticsearchClient.createIndex(createIndexRequest);
        if (created) {
            LOGGER.debug("Index [{}] was successfully created", (Object)indexName);
        } else {
            LOGGER.debug("Index [{}] was NOT created", (Object)indexName);
        }
    }

    private void putIndexTemplate(PutComposableIndexTemplateRequest request) {
        this.putIndexTemplate(request, false);
    }

    private void putIndexTemplate(PutComposableIndexTemplateRequest request, boolean overwrite) {
        boolean created = this.retryElasticsearchClient.createTemplate(request, overwrite);
        if (created) {
            LOGGER.debug("Template [{}] was successfully created", (Object)request.name());
        } else {
            LOGGER.debug("Template [{}] was NOT created", (Object)request.name());
        }
    }
}

