/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.schema;

import com.google.common.collect.Maps;
import io.camunda.operate.exceptions.OperateRuntimeException;
import io.camunda.operate.property.OperateProperties;
import io.camunda.operate.schema.IndexMapping;
import io.camunda.operate.schema.IndexMappingDifference;
import io.camunda.operate.schema.SchemaManager;
import io.camunda.operate.schema.indices.IndexDescriptor;
import io.camunda.operate.schema.migration.SemanticVersion;
import io.camunda.operate.util.CollectionUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class IndexSchemaValidator {
    private static final Logger LOGGER = LoggerFactory.getLogger(IndexSchemaValidator.class);
    private static final Pattern VERSION_PATTERN = Pattern.compile(".*-(\\d+\\.\\d+\\.\\d+.*)_.*");
    @Autowired
    Set<IndexDescriptor> indexDescriptors;
    @Autowired
    SchemaManager schemaManager;
    @Autowired
    private OperateProperties operateProperties;

    private Set<String> getAllIndexNamesForIndex(String index) {
        String indexPattern = String.format("%s-%s*", this.getIndexPrefix(), index);
        LOGGER.debug("Getting all indices for {}", (Object)indexPattern);
        Set<String> indexNames = this.schemaManager.getIndexNames(indexPattern);
        String patternWithVersion = String.format("%s-%s-\\d.*", this.getIndexPrefix(), index);
        return indexNames.stream().filter(n -> n.matches(patternWithVersion)).collect(Collectors.toSet());
    }

    private String getIndexPrefix() {
        return this.schemaManager.getIndexPrefix();
    }

    public Set<String> newerVersionsForIndex(IndexDescriptor indexDescriptor) {
        SemanticVersion currentVersion = SemanticVersion.fromVersion(indexDescriptor.getVersion());
        Set<String> versions = this.versionsForIndex(indexDescriptor);
        return versions.stream().filter(version -> SemanticVersion.fromVersion(version).isNewerThan(currentVersion)).collect(Collectors.toSet());
    }

    public Set<String> olderVersionsForIndex(IndexDescriptor indexDescriptor) {
        SemanticVersion currentVersion = SemanticVersion.fromVersion(indexDescriptor.getVersion());
        Set<String> versions = this.versionsForIndex(indexDescriptor);
        return versions.stream().filter(version -> currentVersion.isNewerThan(SemanticVersion.fromVersion(version))).collect(Collectors.toSet());
    }

    private Set<String> versionsForIndex(IndexDescriptor indexDescriptor) {
        Set<String> allIndexNames = this.getAllIndexNamesForIndex(indexDescriptor.getIndexName());
        return allIndexNames.stream().map(this::getVersionFromIndexName).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet());
    }

    private Optional<String> getVersionFromIndexName(String indexName) {
        Matcher matcher = VERSION_PATTERN.matcher(indexName);
        if (matcher.matches() && matcher.groupCount() > 0) {
            return Optional.of(matcher.group(1));
        }
        return Optional.empty();
    }

    public void validateIndexVersions() {
        if (!this.hasAnyOperateIndices()) {
            return;
        }
        HashSet errors = new HashSet();
        this.indexDescriptors.forEach(indexDescriptor -> {
            Set<String> oldVersions = this.olderVersionsForIndex((IndexDescriptor)indexDescriptor);
            Set<String> newerVersions = this.newerVersionsForIndex((IndexDescriptor)indexDescriptor);
            if (oldVersions.size() > 1) {
                errors.add(String.format("More than one older version for %s (%s) found: %s", indexDescriptor.getIndexName(), indexDescriptor.getVersion(), oldVersions));
            }
            if (!newerVersions.isEmpty()) {
                errors.add(String.format("Newer version(s) for %s (%s) already exists: %s", indexDescriptor.getIndexName(), indexDescriptor.getVersion(), newerVersions));
            }
        });
        if (!errors.isEmpty()) {
            throw new OperateRuntimeException("Error(s) in index schema: " + String.join((CharSequence)";", errors));
        }
    }

    public boolean hasAnyOperateIndices() {
        Set<String> indices = this.schemaManager.getIndexNames(this.schemaManager.getIndexPrefix() + "*");
        return !indices.isEmpty();
    }

    public boolean schemaExists() {
        try {
            Set<String> indices = this.schemaManager.getIndexNames(this.schemaManager.getIndexPrefix() + "*");
            List allIndexNames = CollectionUtil.map(this.indexDescriptors, IndexDescriptor::getFullQualifiedName);
            Set<String> aliases = this.schemaManager.getAliasesNames(this.schemaManager.getIndexPrefix() + "*");
            List allAliasesNames = CollectionUtil.map(this.indexDescriptors, IndexDescriptor::getAlias);
            return indices.containsAll(allIndexNames) && aliases.containsAll(allAliasesNames);
        }
        catch (Exception e) {
            LOGGER.error("Check for existing schema failed", (Throwable)e);
            return false;
        }
    }

    public Map<IndexDescriptor, Set<IndexMapping.IndexMappingProperty>> validateIndexMappings() {
        HashMap<IndexDescriptor, Set<IndexMapping.IndexMappingProperty>> newFields = new HashMap<IndexDescriptor, Set<IndexMapping.IndexMappingProperty>>();
        Map<String, IndexMapping> indexMappings = this.schemaManager.getIndexMappings(this.schemaManager.getIndexPrefix() + "*");
        for (IndexDescriptor indexDescriptor : this.indexDescriptors) {
            Map<String, IndexMapping> indexMappingsGroup = this.filterIndexMappings(indexMappings, indexDescriptor);
            if (indexMappingsGroup.isEmpty()) continue;
            IndexMappingDifference difference = this.getDifference(indexDescriptor, indexMappingsGroup);
            this.validateDifferenceAndCollectNewFields(indexDescriptor, difference, newFields);
        }
        return newFields;
    }

    private IndexMappingDifference getDifference(IndexDescriptor indexDescriptor, Map<String, IndexMapping> indexMappingsGroup) {
        return this.getIndexMappingDifference(indexDescriptor, indexMappingsGroup);
    }

    private void validateDifferenceAndCollectNewFields(IndexDescriptor indexDescriptor, IndexMappingDifference difference, Map<IndexDescriptor, Set<IndexMapping.IndexMappingProperty>> newFields) {
        if (difference != null && !difference.isEqual()) {
            LOGGER.debug(String.format("Index fields differ from expected. Index name: %s. Difference: %s.", indexDescriptor.getIndexName(), difference));
            if (!difference.getEntriesDiffering().isEmpty()) {
                this.validateFieldsDifferBetweenIndices(difference, indexDescriptor);
            }
            if (!difference.getEntriesOnlyOnRight().isEmpty()) {
                String message = String.format("Index name: %s. Field deletion is requested, will be ignored. Fields: %s", indexDescriptor.getIndexName(), difference.getEntriesOnlyOnRight());
                LOGGER.info(message);
            } else if (!difference.getEntriesOnlyOnLeft().isEmpty()) {
                newFields.put(indexDescriptor, difference.getEntriesOnlyOnLeft());
            }
        } else {
            LOGGER.debug(String.format("Index fields are up to date. Index name: %s.", indexDescriptor.getIndexName()));
        }
    }

    private IndexMappingDifference getIndexMappingDifference(IndexDescriptor indexDescriptor, Map<String, IndexMapping> indexMappingsGroup) {
        IndexMapping indexMappingMustBe = this.schemaManager.getExpectedIndexFields(indexDescriptor);
        IndexMappingDifference difference = null;
        for (Map.Entry<String, IndexMapping> singleIndexMapping : indexMappingsGroup.entrySet()) {
            IndexMappingDifference currentDifference = new IndexMappingDifference.IndexMappingDifferenceBuilder().setLeft(indexMappingMustBe).setRight(singleIndexMapping.getValue()).build();
            if (currentDifference.isEqual()) continue;
            if (difference == null) {
                difference = currentDifference;
                continue;
            }
            if (difference.checkEqualityForDifferences(currentDifference)) continue;
            throw new OperateRuntimeException("Ambiguous schema update. First bring runtime and date indices to one schema. Difference 1: " + String.valueOf(difference) + ". Difference 2: " + String.valueOf(currentDifference));
        }
        return difference;
    }

    private Map<String, IndexMapping> filterIndexMappings(Map<String, IndexMapping> indexMappings, IndexDescriptor indexDescriptor) {
        return Maps.filterEntries(indexMappings, e -> ((String)e.getKey()).matches(indexDescriptor.getAllVersionsIndexNameRegexPattern()));
    }

    private boolean indexIsDynamic(IndexMapping mapping) {
        if (mapping == null) {
            return false;
        }
        if (mapping.getDynamic() == null) {
            return true;
        }
        return Boolean.parseBoolean(mapping.getDynamic());
    }

    private void validateFieldsDifferBetweenIndices(IndexMappingDifference difference, IndexDescriptor indexDescriptor) {
        if (this.indexIsDynamic(difference.getLeftIndexMapping())) {
            LOGGER.debug(String.format("Left index name: %s is dynamic, ignoring changes found: %s", indexDescriptor.getIndexName(), difference.getEntriesDiffering()));
        } else if (this.indexIsDynamic(difference.getRightIndexMapping())) {
            LOGGER.debug(String.format("Right index name: %s is dynamic, ignoring changes found: %s", indexDescriptor.getIndexName(), difference.getEntriesDiffering()));
        } else {
            String errorMsg = String.format("Index name: %s. Not supported index changes are introduced. Data migration is required. Changes found: %s", indexDescriptor.getIndexName(), difference.getEntriesDiffering());
            LOGGER.error(errorMsg);
            throw new OperateRuntimeException(errorMsg);
        }
    }
}

