/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.entities;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.camunda.operate.entities.ErrorType;
import io.camunda.operate.entities.IncidentState;
import io.camunda.operate.entities.OperateZeebeEntity;
import java.time.OffsetDateTime;
import java.util.Objects;

public class IncidentEntity
extends OperateZeebeEntity<IncidentEntity> {
    private ErrorType errorType;
    private String errorMessage;
    private Integer errorMessageHash;
    private IncidentState state;
    private String flowNodeId;
    private Long flowNodeInstanceKey;
    private Long jobKey;
    private Long processInstanceKey;
    private OffsetDateTime creationTime;
    private Long processDefinitionKey;
    private String bpmnProcessId;
    private String treePath;
    private String tenantId = "<default>";
    private Long position;
    @Deprecated
    @JsonIgnore
    private boolean pending = true;

    public ErrorType getErrorType() {
        return this.errorType;
    }

    public IncidentEntity setErrorType(ErrorType errorType) {
        this.errorType = errorType;
        return this;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public IncidentEntity setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
        this.setErrorMessageHash(errorMessage.hashCode());
        return this;
    }

    public Integer getErrorMessageHash() {
        return this.errorMessage.hashCode();
    }

    public IncidentEntity setErrorMessageHash(Integer errorMessageHash) {
        this.errorMessageHash = errorMessageHash;
        return this;
    }

    public IncidentState getState() {
        return this.state;
    }

    public IncidentEntity setState(IncidentState state) {
        this.state = state;
        return this;
    }

    public String getFlowNodeId() {
        return this.flowNodeId;
    }

    public IncidentEntity setFlowNodeId(String flowNodeId) {
        this.flowNodeId = flowNodeId;
        return this;
    }

    public Long getFlowNodeInstanceKey() {
        return this.flowNodeInstanceKey;
    }

    public IncidentEntity setFlowNodeInstanceKey(Long flowNodeInstanceId) {
        this.flowNodeInstanceKey = flowNodeInstanceId;
        return this;
    }

    public Long getJobKey() {
        return this.jobKey;
    }

    public IncidentEntity setJobKey(Long jobKey) {
        this.jobKey = jobKey;
        return this;
    }

    public Long getProcessInstanceKey() {
        return this.processInstanceKey;
    }

    public IncidentEntity setProcessInstanceKey(Long processInstanceKey) {
        this.processInstanceKey = processInstanceKey;
        return this;
    }

    public OffsetDateTime getCreationTime() {
        return this.creationTime;
    }

    public IncidentEntity setCreationTime(OffsetDateTime creationTime) {
        this.creationTime = creationTime;
        return this;
    }

    public Long getProcessDefinitionKey() {
        return this.processDefinitionKey;
    }

    public IncidentEntity setProcessDefinitionKey(Long processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
        return this;
    }

    public String getBpmnProcessId() {
        return this.bpmnProcessId;
    }

    public IncidentEntity setBpmnProcessId(String bpmnProcessId) {
        this.bpmnProcessId = bpmnProcessId;
        return this;
    }

    public String getTreePath() {
        return this.treePath;
    }

    public IncidentEntity setTreePath(String treePath) {
        this.treePath = treePath;
        return this;
    }

    public boolean isPending() {
        return this.pending;
    }

    public IncidentEntity setPending(boolean pending) {
        this.pending = pending;
        return this;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public IncidentEntity setTenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    public Long getPosition() {
        return this.position;
    }

    public IncidentEntity setPosition(Long position) {
        this.position = position;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IncidentEntity incident = (IncidentEntity)o;
        return this.pending == incident.pending && this.errorType == incident.errorType && Objects.equals(this.errorMessage, incident.errorMessage) && Objects.equals(this.errorMessageHash, incident.errorMessageHash) && this.state == incident.state && Objects.equals(this.flowNodeId, incident.flowNodeId) && Objects.equals(this.flowNodeInstanceKey, incident.flowNodeInstanceKey) && Objects.equals(this.jobKey, incident.jobKey) && Objects.equals(this.processInstanceKey, incident.processInstanceKey) && Objects.equals(this.creationTime, incident.creationTime) && Objects.equals(this.processDefinitionKey, incident.processDefinitionKey) && Objects.equals(this.bpmnProcessId, incident.bpmnProcessId) && Objects.equals(this.treePath, incident.treePath) && Objects.equals(this.tenantId, incident.tenantId) && Objects.equals(this.position, incident.position);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.errorType, this.errorMessage, this.errorMessageHash, this.state, this.flowNodeId, this.flowNodeInstanceKey, this.jobKey, this.processInstanceKey, this.creationTime, this.processDefinitionKey, this.bpmnProcessId, this.treePath, this.tenantId, this.position});
    }

    @Override
    public String toString() {
        return "IncidentEntity{key=" + this.getKey() + ", errorType=" + String.valueOf((Object)this.errorType) + ", errorMessageHash=" + this.errorMessageHash + ", state=" + String.valueOf((Object)this.state) + ", flowNodeId='" + this.flowNodeId + "', flowNodeInstanceKey=" + this.flowNodeInstanceKey + ", jobKey=" + this.jobKey + ", processInstanceKey=" + this.processInstanceKey + ", creationTime=" + String.valueOf(this.creationTime) + ", processDefinitionKey=" + this.processDefinitionKey + ", bpmnProcessId=" + this.bpmnProcessId + ", treePath='" + this.treePath + "', pending=" + this.pending + "}";
    }
}

