/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.entities;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum ErrorType {
    UNSPECIFIED("Unspecified"),
    UNKNOWN("Unknown"),
    IO_MAPPING_ERROR("I/O mapping error"),
    JOB_NO_RETRIES("No more retries left", true),
    EXECUTION_LISTENER_NO_RETRIES("Execution listener no more retries left", true),
    CONDITION_ERROR("Condition error"),
    EXTRACT_VALUE_ERROR("Extract value error"),
    CALLED_ELEMENT_ERROR("Called element error"),
    UNHANDLED_ERROR_EVENT("Unhandled error event"),
    MESSAGE_SIZE_EXCEEDED("Message size exceeded"),
    CALLED_DECISION_ERROR("Called decision error"),
    DECISION_EVALUATION_ERROR("Decision evaluation error"),
    FORM_NOT_FOUND("Form not found");

    private static final Logger LOGGER;
    private final String title;
    private final boolean resolvedViaRetries;

    private ErrorType(String title) {
        this(title, false);
    }

    private ErrorType(String title, boolean resolvedViaRetries) {
        this.title = title;
        this.resolvedViaRetries = resolvedViaRetries;
    }

    public static ErrorType fromZeebeErrorType(String errorType) {
        if (errorType == null) {
            return UNSPECIFIED;
        }
        try {
            return ErrorType.valueOf(errorType);
        }
        catch (IllegalArgumentException ex) {
            LOGGER.error("Error type not found for value [{}]. UNKNOWN type will be assigned.", (Object)errorType);
            return UNKNOWN;
        }
    }

    public String getTitle() {
        return this.title;
    }

    public boolean isResolvedViaRetries() {
        return this.resolvedViaRetries;
    }

    static {
        LOGGER = LoggerFactory.getLogger(ErrorType.class);
    }
}

