/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.cache;

import io.camunda.operate.entities.ProcessEntity;
import io.camunda.operate.entities.ProcessFlowNodeEntity;
import io.camunda.operate.store.ProcessStore;
import io.camunda.operate.util.ThreadUtil;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class ProcessCache {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessCache.class);
    private static final int CACHE_MAX_SIZE = 100;
    private static final int MAX_ATTEMPTS = 5;
    private static final long WAIT_TIME = 200L;
    private final Map<Long, ProcessEntity> cache = new ConcurrentHashMap<Long, ProcessEntity>();
    @Autowired
    private ProcessStore processStore;

    public String getProcessNameOrDefaultValue(Long processDefinitionKey, String defaultValue) {
        ProcessEntity cachedProcessData = this.getCachedProcessEntity(processDefinitionKey).orElse(null);
        String processName = defaultValue;
        if (cachedProcessData != null) {
            processName = cachedProcessData.getName();
        }
        if (!StringUtils.hasText((String)processName)) {
            LOGGER.debug("ProcessName is empty, use default value: {} ", (Object)defaultValue);
            processName = defaultValue;
        }
        return processName;
    }

    public String getProcessNameOrBpmnProcessId(Long processDefinitionKey, String defaultValue) {
        ProcessEntity cachedProcessData = this.getCachedProcessEntity(processDefinitionKey).orElse(null);
        String processName = null;
        if (cachedProcessData != null && (processName = cachedProcessData.getName()) == null) {
            processName = cachedProcessData.getBpmnProcessId();
        }
        if (!StringUtils.hasText(processName)) {
            LOGGER.debug("ProcessName is empty, use default value: {} ", (Object)defaultValue);
            processName = defaultValue;
        }
        return processName;
    }

    public String getProcessVersionTag(Long processDefinitionKey) {
        ProcessEntity cachedProcessData = this.getCachedProcessEntity(processDefinitionKey).orElse(null);
        String processVersionTag = null;
        if (cachedProcessData != null) {
            processVersionTag = cachedProcessData.getVersionTag();
        }
        return processVersionTag;
    }

    public String getFlowNodeNameOrDefaultValue(Long processDefinitionKey, String flowNodeId, String defaultValue) {
        ProcessFlowNodeEntity flowNodeEntity;
        ProcessEntity cachedProcessData = this.getCachedProcessEntity(processDefinitionKey).orElse(null);
        String flowNodeName = defaultValue;
        if (cachedProcessData != null && flowNodeId != null && (flowNodeEntity = (ProcessFlowNodeEntity)cachedProcessData.getFlowNodes().stream().filter(x -> flowNodeId.equals(x.getId())).findFirst().orElse(null)) != null) {
            flowNodeName = flowNodeEntity.getName();
        }
        if (!StringUtils.hasText((String)flowNodeName)) {
            LOGGER.debug("FlowNodeName is empty, use default value: {} ", (Object)defaultValue);
            flowNodeName = defaultValue;
        }
        return flowNodeName;
    }

    private Optional<ProcessEntity> getCachedProcessEntity(Long processDefinitionKey) {
        Optional<ProcessEntity> processMaybe;
        ProcessEntity cachedProcessData = this.cache.get(processDefinitionKey);
        if (cachedProcessData == null && (processMaybe = this.findOrWaitProcess(processDefinitionKey, 5, 200L)).isPresent()) {
            cachedProcessData = processMaybe.get();
            this.putToCache(processDefinitionKey, cachedProcessData);
        }
        return Optional.ofNullable(cachedProcessData);
    }

    private Optional<ProcessEntity> readProcessByKey(Long processDefinitionKey) {
        try {
            return Optional.of(this.processStore.getProcessByKey(processDefinitionKey));
        }
        catch (Exception ex) {
            return Optional.empty();
        }
    }

    public Optional<ProcessEntity> findOrWaitProcess(Long processDefinitionKey, int attempts, long sleepInMilliseconds) {
        Optional<ProcessEntity> foundProcess = Optional.empty();
        for (int attemptsCount = 0; foundProcess.isEmpty() && attemptsCount < attempts; ++attemptsCount) {
            foundProcess = this.readProcessByKey(processDefinitionKey);
            if (foundProcess.isEmpty()) {
                LOGGER.debug("Unable to find process {}. {} attempts left. Waiting {} ms.", new Object[]{processDefinitionKey, attempts - attemptsCount, sleepInMilliseconds});
                ThreadUtil.sleepFor((long)sleepInMilliseconds);
                continue;
            }
            LOGGER.debug("Found process {} after {} attempts. Waited {} ms.", new Object[]{processDefinitionKey, attemptsCount, (long)(attemptsCount - 1) * sleepInMilliseconds});
        }
        return foundProcess;
    }

    public void putToCache(Long processDefinitionKey, ProcessEntity process) {
        Iterator<Long> iterator;
        if (this.cache.size() >= 100 && (iterator = this.cache.keySet().iterator()).hasNext()) {
            iterator.next();
            iterator.remove();
        }
        this.cache.put(processDefinitionKey, process);
    }

    public void clearCache() {
        this.cache.clear();
    }
}

