/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.tenant;

import io.camunda.operate.conditions.OpensearchCondition;
import io.camunda.operate.tenant.TenantCheckApplier;
import java.util.Optional;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Conditional(value={OpensearchCondition.class})
@Component
public class TenantCheckApplierHolder
implements ApplicationContextAware {
    private static ApplicationContext applicationContext;
    private static TenantCheckApplier<Query> tenantCheckApplier;

    public static synchronized Optional<TenantCheckApplier<Query>> getOpenSearchTenantCheckApplier() {
        try {
            if (tenantCheckApplier == null) {
                tenantCheckApplier = (TenantCheckApplier)applicationContext.getBean(TenantCheckApplier.class);
            }
            return Optional.of(tenantCheckApplier);
        }
        catch (NoSuchBeanDefinitionException ex) {
            tenantCheckApplier = null;
            return Optional.empty();
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        TenantCheckApplierHolder.applicationContext = applicationContext;
    }
}

