/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.tenant;

import io.camunda.operate.conditions.ElasticsearchCondition;
import io.camunda.operate.exceptions.OperateRuntimeException;
import io.camunda.operate.tenant.TenantAwareClient;
import io.camunda.operate.tenant.TenantCheckApplier;
import java.io.IOException;
import java.util.concurrent.Callable;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Conditional(value={ElasticsearchCondition.class})
@Component
public class TenantAwareElasticsearchClient
implements TenantAwareClient<SearchRequest, SearchResponse> {
    @Autowired
    @Qualifier(value="esClient")
    private RestHighLevelClient defaultClient;
    @Autowired(required=false)
    private TenantCheckApplier<SearchRequest> tenantCheckApplier;

    @Override
    public SearchResponse search(SearchRequest searchRequest) throws IOException {
        return this.search(searchRequest, () -> this.defaultClient.search(searchRequest, RequestOptions.DEFAULT));
    }

    @Override
    public <C> C search(SearchRequest searchRequest, Callable<C> searchExecutor) throws IOException {
        this.applyTenantCheckIfPresent(searchRequest);
        try {
            return searchExecutor.call();
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            String message = String.format("Unexpectedly failed to execute search request with %s", e.getMessage());
            throw new OperateRuntimeException(message, e);
        }
    }

    private void applyTenantCheckIfPresent(SearchRequest searchRequest) {
        if (this.tenantCheckApplier != null) {
            this.tenantCheckApplier.apply(searchRequest);
        }
    }
}

