/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.connect;

import io.camunda.operate.conditions.DatabaseInfo;
import io.camunda.operate.property.OperateProperties;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class OperateDateTimeFormatter {
    public static final String RFC3339_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSxxx";
    public static final String DATE_FORMAT_DEFAULT = "yyyy-MM-dd'T'HH:mm:ss.SSSZZ";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final DateTimeFormatter apiDateTimeFormatter;
    private final DateTimeFormatter generalDateTimeFormatter;
    private final String apiDateTimeFormatString;
    private final String generalDateTimeFormatString;
    private final boolean storageAndApiFormatsAreSame;

    public OperateDateTimeFormatter(OperateProperties operateProperties, DatabaseInfo databaseInfo) {
        this.generalDateTimeFormatString = databaseInfo.isOpensearchDb() ? operateProperties.getOpensearch().getDateFormat() : operateProperties.getElasticsearch().getDateFormat();
        if (operateProperties.isRfc3339ApiDateFormat()) {
            this.logger.info("rfc3339ApiDateFormat is set to true, operate API will format datetimes according to the RFC3339 spec");
            this.apiDateTimeFormatString = RFC3339_DATE_FORMAT;
        } else {
            this.logger.info("rfc3339ApiDateFormat is set to false, operate API will format datetimes in the existing format");
            this.apiDateTimeFormatString = this.generalDateTimeFormatString;
        }
        this.storageAndApiFormatsAreSame = this.apiDateTimeFormatString.equals(this.generalDateTimeFormatString);
        this.apiDateTimeFormatter = DateTimeFormatter.ofPattern(this.apiDateTimeFormatString);
        this.generalDateTimeFormatter = DateTimeFormatter.ofPattern(this.generalDateTimeFormatString);
    }

    public String getGeneralDateTimeFormatString() {
        return this.generalDateTimeFormatString;
    }

    public DateTimeFormatter getGeneralDateTimeFormatter() {
        return this.generalDateTimeFormatter;
    }

    public String formatGeneralDateTime(OffsetDateTime dateTime) {
        if (dateTime != null) {
            return dateTime.format(this.generalDateTimeFormatter);
        }
        return null;
    }

    public OffsetDateTime parseGeneralDateTime(String dateTimeAsString) {
        if (StringUtils.isNotEmpty((CharSequence)dateTimeAsString)) {
            return OffsetDateTime.parse(dateTimeAsString, this.generalDateTimeFormatter);
        }
        return null;
    }

    public String getApiDateTimeFormatString() {
        return this.apiDateTimeFormatString;
    }

    public DateTimeFormatter getApiDateTimeFormatter() {
        return this.apiDateTimeFormatter;
    }

    public String formatApiDateTime(OffsetDateTime dateTime) {
        if (dateTime != null) {
            return dateTime.format(this.apiDateTimeFormatter);
        }
        return null;
    }

    public OffsetDateTime parseApiDateTime(String dateTimeAsString) {
        if (StringUtils.isNotEmpty((CharSequence)dateTimeAsString)) {
            return OffsetDateTime.parse(dateTimeAsString, this.apiDateTimeFormatter);
        }
        return null;
    }

    public String convertGeneralToApiDateTime(String dateTimeAsString) {
        if (!this.storageAndApiFormatsAreSame && StringUtils.isNotEmpty((CharSequence)dateTimeAsString)) {
            OffsetDateTime dateTime = this.parseGeneralDateTime(dateTimeAsString);
            return this.formatApiDateTime(dateTime);
        }
        return dateTimeAsString;
    }
}

