/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import io.camunda.operate.connect.CustomInstantDeserializer;
import io.camunda.operate.connect.CustomOffsetDateTimeDeserializer;
import io.camunda.operate.connect.CustomOffsetDateTimeSerializer;
import io.camunda.operate.connect.OperateDateTimeFormatter;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;

@Configuration
public class JacksonConfig {
    @Bean(value={"operateObjectMapper"})
    public ObjectMapper objectMapper(OperateDateTimeFormatter dateTimeFormatter) {
        JavaTimeModule javaTimeModule = new JavaTimeModule();
        javaTimeModule.addSerializer(OffsetDateTime.class, (JsonSerializer)new CustomOffsetDateTimeSerializer(dateTimeFormatter.getGeneralDateTimeFormatter()));
        javaTimeModule.addDeserializer(OffsetDateTime.class, (JsonDeserializer)new CustomOffsetDateTimeDeserializer(dateTimeFormatter.getGeneralDateTimeFormatter()));
        javaTimeModule.addDeserializer(Instant.class, (JsonDeserializer)new CustomInstantDeserializer());
        return Jackson2ObjectMapperBuilder.json().modules(new Module[]{javaTimeModule, new Jdk8Module()}).featuresToDisable(new Object[]{SerializationFeature.INDENT_OUTPUT, SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, DeserializationFeature.ADJUST_DATES_TO_CONTEXT_TIME_ZONE, DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, DeserializationFeature.FAIL_ON_NULL_FOR_PRIMITIVES}).featuresToEnable(new Object[]{JsonParser.Feature.ALLOW_COMMENTS}).visibility(PropertyAccessor.GETTER, JsonAutoDetect.Visibility.ANY).visibility(PropertyAccessor.IS_GETTER, JsonAutoDetect.Visibility.ANY).visibility(PropertyAccessor.SETTER, JsonAutoDetect.Visibility.ANY).visibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.NONE).visibility(PropertyAccessor.CREATOR, JsonAutoDetect.Visibility.ANY).build();
    }

    @Bean
    public DateTimeFormatter dateTimeFormatter(OperateDateTimeFormatter dateTimeFormatter) {
        return dateTimeFormatter.getGeneralDateTimeFormatter();
    }

    @Bean
    public MappingJackson2HttpMessageConverter mappingJackson2HttpMessageConverter(@Qualifier(value="operateObjectMapper") ObjectMapper objectMapper) {
        return new MappingJackson2HttpMessageConverter(objectMapper);
    }
}

