/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.connector.runtime.secret;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import io.camunda.connector.api.secret.SecretProvider;
import io.camunda.connector.runtime.secret.ConsoleSecretApiClient;
import java.time.Duration;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsoleSecretProvider
implements SecretProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConsoleSecretProvider.class);
    private static final String CACHE_KEY = "secrets";
    private final LoadingCache<String, Map<String, String>> secretsCache;

    public ConsoleSecretProvider(final ConsoleSecretApiClient consoleSecretApiClient, Duration cacheRefresh) {
        this.secretsCache = CacheBuilder.newBuilder().refreshAfterWrite(cacheRefresh).build((CacheLoader)new CacheLoader<String, Map<String, String>>(this){

            public Map<String, String> load(String key) {
                return consoleSecretApiClient.getSecrets();
            }
        });
    }

    public String getSecret(String name) {
        LOGGER.debug("Resolving secret for key: " + name);
        return ((Map)this.secretsCache.getUnchecked((Object)CACHE_KEY)).getOrDefault(name, null);
    }
}

