/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.connector.runtime.inbound.webhook;

import io.camunda.connector.api.error.ConnectorException;
import io.camunda.connector.api.inbound.CorrelationFailureHandlingStrategy;
import io.camunda.connector.api.inbound.CorrelationResult;
import io.camunda.connector.api.inbound.webhook.MappedHttpRequest;
import io.camunda.connector.api.inbound.webhook.WebhookConnectorException;
import io.camunda.connector.api.inbound.webhook.WebhookConnectorExecutable;
import io.camunda.connector.api.inbound.webhook.WebhookHttpResponse;
import io.camunda.connector.api.inbound.webhook.WebhookProcessingPayload;
import io.camunda.connector.api.inbound.webhook.WebhookResult;
import io.camunda.connector.api.inbound.webhook.WebhookResultContext;
import io.camunda.connector.api.inbound.webhook.WebhookTriggerResultContext;
import io.camunda.connector.feel.FeelEngineWrapperException;
import io.camunda.connector.runtime.inbound.executable.RegisteredExecutable;
import io.camunda.connector.runtime.inbound.webhook.ErrorResponse;
import io.camunda.connector.runtime.inbound.webhook.FeelExpressionErrorResponse;
import io.camunda.connector.runtime.inbound.webhook.GenericErrorResponse;
import io.camunda.connector.runtime.inbound.webhook.WebhookConnectorRegistry;
import io.camunda.connector.runtime.inbound.webhook.model.HttpServletRequestWebhookProcessingPayload;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.HtmlUtils;

@RestController
public class InboundWebhookRestController {
    private static final Logger LOG = LoggerFactory.getLogger(InboundWebhookRestController.class);
    private final WebhookConnectorRegistry webhookConnectorRegistry;

    @Autowired
    public InboundWebhookRestController(WebhookConnectorRegistry webhookConnectorRegistry) {
        this.webhookConnectorRegistry = webhookConnectorRegistry;
    }

    protected static ResponseEntity<?> toResponseEntity(WebhookHttpResponse webhookHttpResponse) {
        int status = Optional.ofNullable(webhookHttpResponse.statusCode()).orElse(HttpStatus.OK.value());
        HttpHeaders headers = new HttpHeaders();
        Optional.ofNullable(webhookHttpResponse.headers()).orElse(Collections.emptyMap()).forEach((arg_0, arg_1) -> ((HttpHeaders)headers).add(arg_0, arg_1));
        return ((ResponseEntity.BodyBuilder)ResponseEntity.status((int)status).headers(headers)).body(InboundWebhookRestController.escapeValue(webhookHttpResponse.body()));
    }

    protected static Object escapeValue(Object value) {
        Object object = Objects.requireNonNull(value);
        if (object instanceof String) {
            String s = (String)object;
            return HtmlUtils.htmlEscape((String)s);
        }
        return value;
    }

    @RequestMapping(method={RequestMethod.GET, RequestMethod.POST, RequestMethod.PUT, RequestMethod.DELETE}, path={"/inbound/{context}"})
    public ResponseEntity<?> inbound(@PathVariable(value="context") String context, @RequestHeader Map<String, String> headers, @RequestBody(required=false) byte[] bodyAsByteArray, @RequestParam(required=false) Map<String, String> params, HttpServletRequest httpServletRequest) throws IOException {
        LOG.trace("Received inbound hook on {}", (Object)context);
        return this.webhookConnectorRegistry.getWebhookConnectorByContextPath(context).map(connector -> {
            HttpServletRequestWebhookProcessingPayload payload = new HttpServletRequestWebhookProcessingPayload(httpServletRequest, params, headers, bodyAsByteArray);
            return this.processWebhook((RegisteredExecutable.Activated)connector, payload);
        }).orElseGet(() -> ResponseEntity.notFound().build());
    }

    private ResponseEntity<?> processWebhook(RegisteredExecutable.Activated connector, WebhookProcessingPayload payload) {
        ResponseEntity<?> response;
        try {
            WebhookConnectorExecutable connectorHook = (WebhookConnectorExecutable)connector.executable();
            response = this.verify(connectorHook, payload);
            if (response == null) {
                WebhookResult webhookResult = connectorHook.triggerWebhook(payload);
                WebhookTriggerResultContext ctxData = this.toWebhookTriggerResultContext(webhookResult);
                CorrelationResult correlationResult = connector.context().correlateWithResult((Object)ctxData);
                response = this.buildResponse(webhookResult, correlationResult);
            }
        }
        catch (Exception e) {
            LOG.info("Webhook: {} failed with exception", (Object)connector.context().getDefinition(), (Object)e);
            response = this.buildErrorResponse(e);
        }
        return response;
    }

    protected ResponseEntity<?> verify(WebhookConnectorExecutable connectorHook, WebhookProcessingPayload payload) {
        WebhookHttpResponse verificationResponse = connectorHook.verify(payload);
        ResponseEntity<?> response = null;
        if (verificationResponse != null) {
            response = InboundWebhookRestController.toResponseEntity(verificationResponse);
        }
        return response;
    }

    private ResponseEntity<?> buildResponse(WebhookResult webhookResult, CorrelationResult correlationResult) {
        ResponseEntity<?> response;
        if (correlationResult instanceof CorrelationResult.Success) {
            CorrelationResult.Success success = (CorrelationResult.Success)correlationResult;
            response = this.buildSuccessfulResponse(webhookResult, success);
        } else if (correlationResult instanceof CorrelationResult.Failure) {
            CorrelationResult.Failure failure = (CorrelationResult.Failure)correlationResult;
            CorrelationFailureHandlingStrategy correlationFailureHandlingStrategy = failure.handlingStrategy();
            Objects.requireNonNull(correlationFailureHandlingStrategy);
            CorrelationFailureHandlingStrategy correlationFailureHandlingStrategy2 = correlationFailureHandlingStrategy;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{CorrelationFailureHandlingStrategy.ForwardErrorToUpstream.class, CorrelationFailureHandlingStrategy.Ignore.class}, (Object)correlationFailureHandlingStrategy2, n)) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    CorrelationFailureHandlingStrategy.ForwardErrorToUpstream ignored = (CorrelationFailureHandlingStrategy.ForwardErrorToUpstream)correlationFailureHandlingStrategy2;
                    response = this.buildErrorResponse(failure);
                    break;
                }
                case 1: {
                    CorrelationFailureHandlingStrategy.Ignore ignored = (CorrelationFailureHandlingStrategy.Ignore)correlationFailureHandlingStrategy2;
                    response = this.buildSuccessfulResponse(webhookResult, null);
                    break;
                }
            }
        } else {
            throw new IllegalStateException("Illegal correlation result : " + String.valueOf(correlationResult));
        }
        return response;
    }

    private ResponseEntity<?> buildErrorResponse(CorrelationResult.Failure failure) {
        ResponseEntity response = failure instanceof CorrelationResult.Failure.Other ? ResponseEntity.internalServerError().build() : ResponseEntity.unprocessableEntity().body((Object)failure);
        return response;
    }

    private ResponseEntity<?> buildSuccessfulResponse(WebhookResult webhookResult, CorrelationResult.Success correlationResult) {
        ResponseEntity response;
        if (webhookResult.response() != null) {
            WebhookResultContext processVariablesContext = this.toWebhookResultContext(webhookResult, correlationResult);
            WebhookHttpResponse httpResponseData = (WebhookHttpResponse)webhookResult.response().apply(processVariablesContext);
            response = httpResponseData != null ? InboundWebhookRestController.toResponseEntity(httpResponseData) : ResponseEntity.ok().build();
        } else {
            response = ResponseEntity.ok().build();
        }
        return response;
    }

    protected ResponseEntity<?> buildErrorResponse(Exception e) {
        ResponseEntity response;
        if (e instanceof FeelEngineWrapperException) {
            FeelEngineWrapperException feelEngineWrapperException = (FeelEngineWrapperException)e;
            FeelExpressionErrorResponse error = new FeelExpressionErrorResponse(feelEngineWrapperException.getReason(), feelEngineWrapperException.getExpression());
            response = ResponseEntity.unprocessableEntity().body((Object)error);
        } else if (e instanceof ConnectorException) {
            ConnectorException connectorException = (ConnectorException)e;
            if (e instanceof WebhookConnectorException) {
                WebhookConnectorException webhookConnectorException = (WebhookConnectorException)e;
                response = this.handleWebhookConnectorException(webhookConnectorException);
            } else {
                response = ResponseEntity.unprocessableEntity().body((Object)new ErrorResponse(connectorException.getErrorCode(), connectorException.getMessage()));
            }
        } else {
            response = ResponseEntity.internalServerError().build();
        }
        return response;
    }

    private WebhookTriggerResultContext toWebhookTriggerResultContext(WebhookResult processedResult) {
        WebhookTriggerResultContext ctx = new WebhookTriggerResultContext(null, null);
        if (processedResult != null) {
            ctx = new WebhookTriggerResultContext(new MappedHttpRequest(Optional.ofNullable(processedResult.request().body()).orElse(Collections.emptyMap()), Optional.ofNullable(processedResult.request().headers()).orElse(Collections.emptyMap()), Optional.ofNullable(processedResult.request().params()).orElse(Collections.emptyMap())), Optional.ofNullable(processedResult.connectorData()).orElse(Collections.emptyMap()));
        }
        return ctx;
    }

    private WebhookResultContext toWebhookResultContext(WebhookResult processedResult, CorrelationResult.Success correlationResult) {
        WebhookResultContext ctx = new WebhookResultContext(null, null, null);
        if (processedResult != null) {
            CorrelationResult.Success correlation = null;
            if (correlationResult instanceof CorrelationResult.Success.ProcessInstanceCreated || correlationResult instanceof CorrelationResult.Success.MessagePublished) {
                correlation = correlationResult;
            }
            ctx = new WebhookResultContext(new MappedHttpRequest(Optional.ofNullable(processedResult.request().body()).orElse(Collections.emptyMap()), Optional.ofNullable(processedResult.request().headers()).orElse(Collections.emptyMap()), Optional.ofNullable(processedResult.request().params()).orElse(Collections.emptyMap())), Optional.ofNullable(processedResult.connectorData()).orElse(Collections.emptyMap()), Optional.ofNullable(correlation).orElse((CorrelationResult.Success)Collections.emptyMap()));
        }
        return ctx;
    }

    private ResponseEntity<?> handleWebhookConnectorException(WebhookConnectorException e) {
        HttpStatus status = HttpStatus.valueOf((int)e.getStatusCode());
        ResponseEntity response = ResponseEntity.status((HttpStatusCode)status).build();
        if (e instanceof WebhookConnectorException.WebhookSecurityException) {
            LOG.warn("Webhook failed with security-related exception", (Throwable)e);
            response = ResponseEntity.status((HttpStatusCode)status).body(null);
        }
        if (status.is5xxServerError()) {
            LOG.error("Webhook failed with exception", (Throwable)e);
            response = ResponseEntity.status((HttpStatusCode)status).body(null);
        }
        if (status.is4xxClientError()) {
            response = ResponseEntity.status((HttpStatusCode)status).body((Object)new GenericErrorResponse(e.getMessage()));
        }
        return response;
    }
}

