/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.connector.runtime.inbound.importer;

import io.camunda.connector.runtime.inbound.importer.ProcessDefinitionSearch;
import io.camunda.connector.runtime.inbound.state.ProcessImportResult;
import io.camunda.connector.runtime.inbound.state.ProcessStateStore;
import io.camunda.operate.model.ProcessDefinition;
import io.camunda.zeebe.spring.client.metrics.MetricsRecorder;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;

public class ProcessDefinitionImporter {
    private static final Logger LOG = LoggerFactory.getLogger(ProcessDefinitionImporter.class);
    private final ProcessStateStore stateStore;
    private final ProcessDefinitionSearch search;
    private final MetricsRecorder metricsRecorder;
    private boolean ready = true;

    @Autowired
    public ProcessDefinitionImporter(ProcessStateStore stateStore, ProcessDefinitionSearch search, @Autowired(required=false) MetricsRecorder metricsRecorder) {
        this.stateStore = stateStore;
        this.search = search;
        this.metricsRecorder = metricsRecorder;
    }

    @Scheduled(fixedDelayString="${camunda.connector.polling.interval:5000}")
    public synchronized void scheduleImport() {
        try {
            List<ProcessDefinition> result = this.search.query();
            this.handleImportedDefinitions(result);
            this.ready = true;
        }
        catch (Exception e) {
            LOG.error("Failed to import process elements", (Throwable)e);
            this.ready = false;
        }
    }

    public void handleImportedDefinitions(List<ProcessDefinition> definitions) {
        if (definitions.isEmpty()) {
            return;
        }
        try {
            this.meter(definitions.size());
            ProcessImportResult result = new ProcessImportResult(definitions.stream().collect(Collectors.toMap(definition -> new ProcessImportResult.ProcessDefinitionIdentifier(definition.getBpmnProcessId(), definition.getTenantId()), definition -> new ProcessImportResult.ProcessDefinitionVersion(definition.getKey(), definition.getVersion().intValue()))));
            this.stateStore.update(result);
        }
        catch (Exception e) {
            LOG.error("Failed to handle imported definitions", (Throwable)e);
        }
    }

    private void meter(int count) {
        if (this.metricsRecorder != null) {
            this.metricsRecorder.increase("camunda.connector.inbound.process-elements-checked", null, null, count);
        }
    }

    public boolean isReady() {
        return this.ready;
    }
}

