/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.connector.runtime.inbound.controller;

import io.camunda.connector.api.inbound.Activity;
import io.camunda.connector.api.inbound.InboundConnectorExecutable;
import io.camunda.connector.api.inbound.webhook.WebhookConnectorExecutable;
import io.camunda.connector.runtime.core.inbound.InboundConnectorElement;
import io.camunda.connector.runtime.inbound.controller.ActiveInboundConnectorResponse;
import io.camunda.connector.runtime.inbound.executable.ActiveExecutableQuery;
import io.camunda.connector.runtime.inbound.executable.ActiveExecutableResponse;
import io.camunda.connector.runtime.inbound.executable.InboundExecutableRegistry;
import io.camunda.connector.runtime.inbound.executable.InboundExecutableRegistryImpl;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class InboundConnectorRestController {
    private static final Logger LOG = LoggerFactory.getLogger(InboundConnectorRestController.class);
    private final InboundExecutableRegistry executableRegistry;

    public InboundConnectorRestController(InboundExecutableRegistry executableRegistry) {
        this.executableRegistry = executableRegistry;
    }

    @GetMapping(value={"/inbound"})
    public List<ActiveInboundConnectorResponse> getActiveInboundConnectors(@RequestParam(required=false, value="bpmnProcessId") String bpmnProcessId, @RequestParam(required=false, value="elementId") String elementId, @RequestParam(required=false, value="type") String type) {
        return this.getActiveInboundConnectors(bpmnProcessId, elementId, type, null);
    }

    @PostMapping(value={"/inbound/logs"})
    public void logActiveInboundConnectors() {
        ((InboundExecutableRegistryImpl)this.executableRegistry).logStatusReport();
    }

    @GetMapping(value={"/tenants/{tenantId}/inbound"})
    public List<ActiveInboundConnectorResponse> getActiveInboundConnectorsForTenantId(@PathVariable(value="tenantId") String tenantId, @RequestParam(required=false, value="bpmnProcessId") String bpmnProcessId, @RequestParam(required=false, value="elementId") String elementId, @RequestParam(required=false, value="type") String type) {
        return this.getActiveInboundConnectors(bpmnProcessId, elementId, type, tenantId);
    }

    @GetMapping(value={"/tenants/{tenantId}/inbound/{bpmnProcessId}/{elementId}/logs"})
    public List<Collection<Activity>> getActiveInboundConnectorLogs(@PathVariable(value="tenantId") String tenantId, @PathVariable(value="bpmnProcessId") String bpmnProcessId, @PathVariable(value="elementId") String elementId) {
        List<ActiveExecutableResponse> result = this.executableRegistry.query(new ActiveExecutableQuery(bpmnProcessId, elementId, null, tenantId));
        return result.stream().map(ActiveExecutableResponse::logs).collect(Collectors.toList());
    }

    private List<ActiveInboundConnectorResponse> getActiveInboundConnectors(String bpmnProcessId, String elementId, String type, String tenantId) {
        return this.executableRegistry.query(new ActiveExecutableQuery(bpmnProcessId, elementId, type, tenantId)).stream().map(this::mapToInboundResponse).collect(Collectors.toList());
    }

    private Map<String, Object> getData(ActiveExecutableResponse connector) {
        Map<String, Object> data = Map.of();
        Class<? extends InboundConnectorExecutable> executableClass = connector.executableClass();
        if (executableClass != null && WebhookConnectorExecutable.class.isAssignableFrom(executableClass)) {
            try {
                Map properties = connector.elements().getFirst().connectorLevelProperties();
                String contextPath = (String)properties.get("inbound.context");
                data = Map.of("path", contextPath);
            }
            catch (Exception e) {
                LOG.error("ERROR: webhook connector doesn't have context path property", (Throwable)e);
            }
        }
        return data;
    }

    private ActiveInboundConnectorResponse mapToInboundResponse(ActiveExecutableResponse connector) {
        List<InboundConnectorElement> elements = connector.elements();
        String type = elements.getFirst().type();
        String tenantId = elements.getFirst().element().tenantId();
        return new ActiveInboundConnectorResponse(connector.executableId(), type, tenantId, elements.stream().map(InboundConnectorElement::element).toList(), this.getData(connector), connector.health());
    }
}

