/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.connector.runtime.inbound;

import io.camunda.connector.api.annotation.InboundConnector;
import io.camunda.connector.api.inbound.InboundConnectorExecutable;
import io.camunda.connector.runtime.core.config.InboundConnectorConfiguration;
import io.camunda.connector.runtime.core.inbound.InboundConnectorFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;

public class InboundConnectorBeanDefinitionProcessor
implements BeanDefinitionRegistryPostProcessor,
BeanPostProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(InboundConnectorBeanDefinitionProcessor.class);
    private final List<InboundConnectorConfiguration> preparedConfigurations = new ArrayList<InboundConnectorConfiguration>();

    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
        ListableBeanFactory listableBeanFactory = (ListableBeanFactory)registry;
        String[] handlerBeans = listableBeanFactory.getBeanNamesForType(InboundConnectorExecutable.class, true, false);
        LOG.info("Found inbound connector beans: {}", (Object)handlerBeans);
        for (String beanName : handlerBeans) {
            BeanDefinition beanDefinition = registry.getBeanDefinition(beanName);
            InboundConnector inboundConnectorAnnotation = (InboundConnector)listableBeanFactory.findAnnotationOnBean(beanName, InboundConnector.class);
            if (inboundConnectorAnnotation == null) continue;
            InboundConnectorConfiguration configuration = this.getProperties(inboundConnectorAnnotation, beanDefinition, beanName, (BeanFactory)listableBeanFactory);
            this.preparedConfigurations.add(configuration);
        }
    }

    private InboundConnectorConfiguration getProperties(InboundConnector inboundConnector, BeanDefinition beanDefinition, String beanName, BeanFactory beanFactory) {
        String scope = beanDefinition.getScope();
        if (!"prototype".equals(scope)) {
            throw new IllegalStateException("Only \"prototype\" scope is supported for inbound connectors but found: \"" + scope + "\" for bean: " + String.valueOf(beanDefinition));
        }
        return this.getInboundConnectorConfiguration(inboundConnector, beanName, beanFactory);
    }

    private InboundConnectorConfiguration getInboundConnectorConfiguration(InboundConnector inboundConnector, String beanName, BeanFactory beanFactory) {
        List<String> deduplicationProperties = Arrays.asList(inboundConnector.deduplicationProperties());
        InboundConnectorConfiguration configuration = new InboundConnectorConfiguration(inboundConnector.name(), inboundConnector.type(), null, () -> (InboundConnectorExecutable)beanFactory.getBean(beanName, InboundConnectorExecutable.class), deduplicationProperties);
        LOG.debug("Creating inbound connector configuration from bean {}: {}", (Object)beanName, (Object)configuration);
        return configuration;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof InboundConnectorFactory) {
            InboundConnectorFactory inboundConnectorFactory = (InboundConnectorFactory)bean;
            LOG.info("Configuring {} inbound connectors from bean context", (Object)this.preparedConfigurations.size());
            this.preparedConfigurations.forEach(arg_0 -> ((InboundConnectorFactory)inboundConnectorFactory).registerConfiguration(arg_0));
        }
        return bean;
    }
}

