/*
 * Tasklist REST API
 * Tasklist is a ready-to-use API application to rapidly implement business processes alongside user tasks in Zeebe.
 *
 * The version of the OpenAPI document: v1
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package io.camunda.tasklist.generated.api;

import com.fasterxml.jackson.core.type.TypeReference;

import io.camunda.tasklist.generated.invoker.ApiException;
import io.camunda.tasklist.generated.invoker.ApiClient;
import io.camunda.tasklist.generated.invoker.BaseApi;
import io.camunda.tasklist.generated.invoker.Configuration;
import io.camunda.tasklist.generated.invoker.Pair;

import io.camunda.tasklist.generated.model.UserTaskAssignmentRequest;
import io.camunda.tasklist.generated.model.UserTaskCompletionRequest;
import io.camunda.tasklist.generated.model.UserTaskUpdateRequest;


import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-10-18T04:44:54.772534150Z[Etc/UTC]", comments = "Generator version: 7.8.0")
public class UserTaskControllerApi extends BaseApi {

  public UserTaskControllerApi() {
    super(Configuration.getDefaultApiClient());
  }

  public UserTaskControllerApi(ApiClient apiClient) {
    super(apiClient);
  }

  /**
   * 
   * 
   * @param userTaskKey  (required)
   * @param userTaskAssignmentRequest  (required)
   * @return Object
   * @throws ApiException if fails to make API call
   */
  public Object assignUserTask(Long userTaskKey, UserTaskAssignmentRequest userTaskAssignmentRequest) throws ApiException {
    return this.assignUserTask(userTaskKey, userTaskAssignmentRequest, Collections.emptyMap());
  }


  /**
   * 
   * 
   * @param userTaskKey  (required)
   * @param userTaskAssignmentRequest  (required)
   * @param additionalHeaders additionalHeaders for this call
   * @return Object
   * @throws ApiException if fails to make API call
   */
  public Object assignUserTask(Long userTaskKey, UserTaskAssignmentRequest userTaskAssignmentRequest, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = userTaskAssignmentRequest;
    
    // verify the required parameter 'userTaskKey' is set
    if (userTaskKey == null) {
      throw new ApiException(400, "Missing the required parameter 'userTaskKey' when calling assignUserTask");
    }
    
    // verify the required parameter 'userTaskAssignmentRequest' is set
    if (userTaskAssignmentRequest == null) {
      throw new ApiException(400, "Missing the required parameter 'userTaskAssignmentRequest' when calling assignUserTask");
    }
    
    // create path and map variables
    String localVarPath = "/v1/user-tasks/{userTaskKey}/assignment"
      .replaceAll("\\{" + "userTaskKey" + "\\}", apiClient.escapeString(userTaskKey.toString()));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json", "application/problem+json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "cookie", "bearer-key" };

    TypeReference<Object> localVarReturnType = new TypeReference<Object>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * 
   * 
   * @param userTaskKey  (required)
   * @param userTaskCompletionRequest  (optional)
   * @return Object
   * @throws ApiException if fails to make API call
   */
  public Object completeUserTask(Long userTaskKey, UserTaskCompletionRequest userTaskCompletionRequest) throws ApiException {
    return this.completeUserTask(userTaskKey, userTaskCompletionRequest, Collections.emptyMap());
  }


  /**
   * 
   * 
   * @param userTaskKey  (required)
   * @param userTaskCompletionRequest  (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @return Object
   * @throws ApiException if fails to make API call
   */
  public Object completeUserTask(Long userTaskKey, UserTaskCompletionRequest userTaskCompletionRequest, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = userTaskCompletionRequest;
    
    // verify the required parameter 'userTaskKey' is set
    if (userTaskKey == null) {
      throw new ApiException(400, "Missing the required parameter 'userTaskKey' when calling completeUserTask");
    }
    
    // create path and map variables
    String localVarPath = "/v1/user-tasks/{userTaskKey}/completion"
      .replaceAll("\\{" + "userTaskKey" + "\\}", apiClient.escapeString(userTaskKey.toString()));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json", "application/problem+json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "cookie", "bearer-key" };

    TypeReference<Object> localVarReturnType = new TypeReference<Object>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * 
   * 
   * @param userTaskKey  (required)
   * @return Object
   * @throws ApiException if fails to make API call
   */
  public Object unassignUserTask(Long userTaskKey) throws ApiException {
    return this.unassignUserTask(userTaskKey, Collections.emptyMap());
  }


  /**
   * 
   * 
   * @param userTaskKey  (required)
   * @param additionalHeaders additionalHeaders for this call
   * @return Object
   * @throws ApiException if fails to make API call
   */
  public Object unassignUserTask(Long userTaskKey, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'userTaskKey' is set
    if (userTaskKey == null) {
      throw new ApiException(400, "Missing the required parameter 'userTaskKey' when calling unassignUserTask");
    }
    
    // create path and map variables
    String localVarPath = "/v1/user-tasks/{userTaskKey}/assignee"
      .replaceAll("\\{" + "userTaskKey" + "\\}", apiClient.escapeString(userTaskKey.toString()));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "*/*"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "cookie", "bearer-key" };

    TypeReference<Object> localVarReturnType = new TypeReference<Object>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "DELETE",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * 
   * 
   * @param userTaskKey  (required)
   * @param userTaskUpdateRequest  (optional)
   * @return Object
   * @throws ApiException if fails to make API call
   */
  public Object updateUserTask(Long userTaskKey, UserTaskUpdateRequest userTaskUpdateRequest) throws ApiException {
    return this.updateUserTask(userTaskKey, userTaskUpdateRequest, Collections.emptyMap());
  }


  /**
   * 
   * 
   * @param userTaskKey  (required)
   * @param userTaskUpdateRequest  (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @return Object
   * @throws ApiException if fails to make API call
   */
  public Object updateUserTask(Long userTaskKey, UserTaskUpdateRequest userTaskUpdateRequest, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = userTaskUpdateRequest;
    
    // verify the required parameter 'userTaskKey' is set
    if (userTaskKey == null) {
      throw new ApiException(400, "Missing the required parameter 'userTaskKey' when calling updateUserTask");
    }
    
    // create path and map variables
    String localVarPath = "/v1/user-tasks/{userTaskKey}"
      .replaceAll("\\{" + "userTaskKey" + "\\}", apiClient.escapeString(userTaskKey.toString()));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json", "application/problem+json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "cookie", "bearer-key" };

    TypeReference<Object> localVarReturnType = new TypeReference<Object>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "PATCH",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  @Override
  public <T> T invokeAPI(String url, String method, Object request, TypeReference<T> returnType, Map<String, String> additionalHeaders) throws ApiException {
    String localVarPath = url.replace(apiClient.getBaseURL(), "");
    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarHeaderParams.putAll(additionalHeaders);

    final String[] localVarAccepts = {
      "application/json", "application/problem+json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "cookie", "bearer-key" };

    return apiClient.invokeAPI(
      localVarPath,
        method,
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        request,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        returnType
    );
  }
}
