/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl.search.response;

import io.camunda.client.api.search.enums.BatchOperationState;
import io.camunda.client.api.search.enums.BatchOperationType;
import io.camunda.client.api.search.response.BatchOperation;
import io.camunda.client.api.search.response.BatchOperationError;
import io.camunda.client.impl.search.response.BatchOperationErrorImpl;
import io.camunda.client.impl.util.EnumUtil;
import io.camunda.client.impl.util.ParseUtil;
import io.camunda.client.protocol.rest.BatchOperationCreatedResult;
import io.camunda.client.protocol.rest.BatchOperationResponse;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class BatchOperationImpl
implements BatchOperation {
    private final String batchOperationKey;
    private final BatchOperationType type;
    private final BatchOperationState status;
    private final OffsetDateTime startDate;
    private final OffsetDateTime endDate;
    private final Integer operationsTotalCount;
    private final Integer operationsFailedCount;
    private final Integer operationsCompletedCount;
    private final List<Long> keys = new ArrayList<Long>();
    private final List<BatchOperationError> errors = new ArrayList<BatchOperationError>();

    public BatchOperationImpl(BatchOperationCreatedResult item) {
        this.batchOperationKey = item.getBatchOperationKey();
        this.type = EnumUtil.convert(item.getBatchOperationType(), BatchOperationType.class);
        this.status = null;
        this.startDate = null;
        this.endDate = null;
        this.operationsTotalCount = null;
        this.operationsFailedCount = null;
        this.operationsCompletedCount = null;
    }

    public BatchOperationImpl(BatchOperationResponse item) {
        this.batchOperationKey = item.getBatchOperationKey();
        this.type = EnumUtil.convert(item.getBatchOperationType(), BatchOperationType.class);
        this.status = item.getState() != null ? BatchOperationState.valueOf(item.getState().name()) : null;
        this.startDate = ParseUtil.parseOffsetDateTimeOrNull(item.getStartDate());
        this.endDate = ParseUtil.parseOffsetDateTimeOrNull(item.getEndDate());
        this.operationsTotalCount = item.getOperationsTotalCount();
        this.operationsFailedCount = item.getOperationsFailedCount();
        this.operationsCompletedCount = item.getOperationsCompletedCount();
        if (item.getErrors() != null && !item.getErrors().isEmpty()) {
            this.errors.addAll(item.getErrors().stream().map(BatchOperationErrorImpl::new).collect(Collectors.toList()));
        }
    }

    @Override
    public String getBatchOperationKey() {
        return this.batchOperationKey;
    }

    @Override
    public BatchOperationState getStatus() {
        return this.status;
    }

    @Override
    public BatchOperationType getType() {
        return this.type;
    }

    @Override
    public OffsetDateTime getStartDate() {
        return this.startDate;
    }

    @Override
    public OffsetDateTime getEndDate() {
        return this.endDate;
    }

    @Override
    public Integer getOperationsTotalCount() {
        return this.operationsTotalCount;
    }

    @Override
    public Integer getOperationsFailedCount() {
        return this.operationsFailedCount;
    }

    @Override
    public Integer getOperationsCompletedCount() {
        return this.operationsCompletedCount;
    }

    @Override
    public List<BatchOperationError> getErrors() {
        return new ArrayList<BatchOperationError>(this.errors);
    }
}

