/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl.search.request;

import io.camunda.client.api.CamundaFuture;
import io.camunda.client.api.JsonMapper;
import io.camunda.client.api.search.request.FinalSearchRequestStep;
import io.camunda.client.api.search.request.ProcessDefinitionSearchRequest;
import io.camunda.client.api.search.request.SearchRequestBuilders;
import io.camunda.client.api.search.request.SearchRequestPage;
import io.camunda.client.api.search.response.ProcessDefinition;
import io.camunda.client.api.search.response.SearchResponse;
import io.camunda.client.api.search.sort.ProcessDefinitionSort;
import io.camunda.client.impl.http.HttpCamundaFuture;
import io.camunda.client.impl.http.HttpClient;
import io.camunda.client.impl.search.request.SearchRequestSortMapper;
import io.camunda.client.impl.search.request.TypedSearchRequestPropertyProvider;
import io.camunda.client.impl.search.response.SearchResponseMapper;
import io.camunda.client.protocol.rest.ProcessDefinitionFilter;
import io.camunda.client.protocol.rest.ProcessDefinitionSearchQuery;
import io.camunda.client.protocol.rest.ProcessDefinitionSearchQueryResult;
import io.camunda.client.protocol.rest.SearchQueryPageRequest;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.hc.client5.http.config.RequestConfig;

public class ProcessDefinitionSearchRequestImpl
extends TypedSearchRequestPropertyProvider<ProcessDefinitionSearchQuery>
implements ProcessDefinitionSearchRequest {
    private final ProcessDefinitionSearchQuery request = new ProcessDefinitionSearchQuery();
    private final JsonMapper jsonMapper;
    private final HttpClient httpClient;
    private final RequestConfig.Builder httpRequestConfig;

    public ProcessDefinitionSearchRequestImpl(HttpClient httpClient, JsonMapper jsonMapper) {
        this.jsonMapper = jsonMapper;
        this.httpClient = httpClient;
        this.httpRequestConfig = httpClient.newRequestConfig();
    }

    @Override
    public FinalSearchRequestStep<ProcessDefinition> requestTimeout(Duration requestTimeout) {
        this.httpRequestConfig.setResponseTimeout(requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public CamundaFuture<SearchResponse<ProcessDefinition>> send() {
        HttpCamundaFuture<SearchResponse<ProcessDefinition>> result = new HttpCamundaFuture<SearchResponse<ProcessDefinition>>();
        this.httpClient.post("/process-definitions/search", this.jsonMapper.toJson(this.request), this.httpRequestConfig.build(), ProcessDefinitionSearchQueryResult.class, SearchResponseMapper::toProcessDefinitionSearchResponse, result);
        return result;
    }

    @Override
    public ProcessDefinitionSearchRequest filter(io.camunda.client.api.search.filter.ProcessDefinitionFilter value) {
        this.request.setFilter((ProcessDefinitionFilter)ProcessDefinitionSearchRequestImpl.provideSearchRequestProperty(value));
        return this;
    }

    @Override
    public ProcessDefinitionSearchRequest filter(Consumer<io.camunda.client.api.search.filter.ProcessDefinitionFilter> fn) {
        return this.filter(SearchRequestBuilders.processDefinitionFilter(fn));
    }

    @Override
    public ProcessDefinitionSearchRequest sort(ProcessDefinitionSort value) {
        this.request.setSort(SearchRequestSortMapper.toProcessDefinitionSearchQuerySortRequest((List)ProcessDefinitionSearchRequestImpl.provideSearchRequestProperty(value)));
        return this;
    }

    @Override
    public ProcessDefinitionSearchRequest sort(Consumer<ProcessDefinitionSort> fn) {
        return this.sort(SearchRequestBuilders.processDefinitionSort(fn));
    }

    @Override
    public ProcessDefinitionSearchRequest page(SearchRequestPage value) {
        this.request.setPage((SearchQueryPageRequest)ProcessDefinitionSearchRequestImpl.provideSearchRequestProperty(value));
        return this;
    }

    @Override
    public ProcessDefinitionSearchRequest page(Consumer<SearchRequestPage> fn) {
        return this.page(SearchRequestBuilders.searchRequestPage(fn));
    }

    @Override
    protected ProcessDefinitionSearchQuery getSearchRequestProperty() {
        return this.request;
    }
}

