/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl.fetch;

import io.camunda.client.api.CamundaFuture;
import io.camunda.client.api.command.FinalCommandStep;
import io.camunda.client.api.fetch.IncidentGetRequest;
import io.camunda.client.api.search.response.Incident;
import io.camunda.client.impl.http.HttpCamundaFuture;
import io.camunda.client.impl.http.HttpClient;
import io.camunda.client.impl.search.response.SearchResponseMapper;
import io.camunda.client.protocol.rest.IncidentResult;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.apache.hc.client5.http.config.RequestConfig;

public class IncidentGetRequestImpl
implements IncidentGetRequest {
    private final HttpClient httpClient;
    private final RequestConfig.Builder httpRequestConfig;
    private final long incidentKey;

    public IncidentGetRequestImpl(HttpClient httpClient, long incidentKey) {
        this.httpClient = httpClient;
        this.httpRequestConfig = httpClient.newRequestConfig();
        this.incidentKey = incidentKey;
    }

    @Override
    public FinalCommandStep<Incident> requestTimeout(Duration requestTimeout) {
        this.httpRequestConfig.setResponseTimeout(requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public CamundaFuture<Incident> send() {
        HttpCamundaFuture<Incident> result = new HttpCamundaFuture<Incident>();
        this.httpClient.get(String.format("/incidents/%d", this.incidentKey), this.httpRequestConfig.build(), IncidentResult.class, SearchResponseMapper::toIncidentGetResponse, result);
        return result;
    }
}

