/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl.fetch;

import io.camunda.client.api.CamundaFuture;
import io.camunda.client.api.command.FinalCommandStep;
import io.camunda.client.api.fetch.AuthorizationGetRequest;
import io.camunda.client.api.search.response.Authorization;
import io.camunda.client.impl.command.ArgumentUtil;
import io.camunda.client.impl.http.HttpCamundaFuture;
import io.camunda.client.impl.http.HttpClient;
import io.camunda.client.impl.search.response.SearchResponseMapper;
import io.camunda.client.protocol.rest.AuthorizationResult;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.apache.hc.client5.http.config.RequestConfig;

public class AuthorizationGetRequestImpl
implements AuthorizationGetRequest {
    private final HttpClient httpClient;
    private final RequestConfig.Builder httpRequestConfig;
    private final long authorizationKey;

    public AuthorizationGetRequestImpl(HttpClient httpClient, long authorizationKey) {
        this.httpClient = httpClient;
        this.httpRequestConfig = httpClient.newRequestConfig();
        this.authorizationKey = authorizationKey;
    }

    @Override
    public FinalCommandStep<Authorization> requestTimeout(Duration requestTimeout) {
        this.httpRequestConfig.setResponseTimeout(requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public CamundaFuture<Authorization> send() {
        ArgumentUtil.ensureGreaterThan("authorizationKey", this.authorizationKey, 0L);
        HttpCamundaFuture<Authorization> result = new HttpCamundaFuture<Authorization>();
        this.httpClient.get(String.format("/authorizations/%d", this.authorizationKey), this.httpRequestConfig.build(), AuthorizationResult.class, SearchResponseMapper::toAuthorizationResponse, result);
        return result;
    }
}

