/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl.command;

import io.camunda.client.CredentialsProvider;
import io.camunda.client.api.CamundaFuture;
import io.camunda.client.api.command.FinalCommandStep;
import io.camunda.client.api.command.TopologyRequestStep1;
import io.camunda.client.api.response.Topology;
import io.camunda.client.impl.RetriableClientFutureImpl;
import io.camunda.client.impl.http.HttpCamundaFuture;
import io.camunda.client.impl.http.HttpClient;
import io.camunda.client.impl.response.TopologyImpl;
import io.camunda.client.protocol.rest.TopologyResponse;
import io.camunda.zeebe.gateway.protocol.GatewayGrpc;
import io.camunda.zeebe.gateway.protocol.GatewayOuterClass;
import io.grpc.stub.StreamObserver;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import org.apache.hc.client5.http.config.RequestConfig;

public final class TopologyRequestImpl
implements TopologyRequestStep1 {
    private final GatewayGrpc.GatewayStub asyncStub;
    private final HttpClient httpClient;
    private final RequestConfig.Builder httpRequestConfig;
    private final Predicate<CredentialsProvider.StatusCode> retryPredicate;
    private Duration requestTimeout;
    private boolean useRest;

    public TopologyRequestImpl(GatewayGrpc.GatewayStub asyncStub, HttpClient httpClient, Duration requestTimeout, Predicate<CredentialsProvider.StatusCode> retryPredicate, boolean useRest) {
        this.asyncStub = asyncStub;
        this.requestTimeout = requestTimeout;
        this.retryPredicate = retryPredicate;
        this.httpClient = httpClient;
        this.httpRequestConfig = httpClient.newRequestConfig();
        this.useRest = useRest;
    }

    @Override
    public TopologyRequestStep1 useRest() {
        this.useRest = true;
        return this;
    }

    @Override
    public TopologyRequestStep1 useGrpc() {
        this.useRest = false;
        return this;
    }

    @Override
    public FinalCommandStep<Topology> requestTimeout(Duration requestTimeout) {
        this.requestTimeout = requestTimeout;
        return this;
    }

    @Override
    public CamundaFuture<Topology> send() {
        if (this.useRest) {
            return this.sendRestRequest();
        }
        return this.sendGrpcRequest();
    }

    private HttpCamundaFuture<Topology> sendRestRequest() {
        HttpCamundaFuture<Topology> result = new HttpCamundaFuture<Topology>();
        this.sendHttpRequest(result);
        return result;
    }

    private RetriableClientFutureImpl<Topology, GatewayOuterClass.TopologyResponse> sendGrpcRequest() {
        GatewayOuterClass.TopologyRequest request = GatewayOuterClass.TopologyRequest.getDefaultInstance();
        RetriableClientFutureImpl<Topology, GatewayOuterClass.TopologyResponse> future = new RetriableClientFutureImpl<Topology, GatewayOuterClass.TopologyResponse>(TopologyImpl::new, this.retryPredicate, streamObserver -> this.sendGrpcRequest(request, (StreamObserver<GatewayOuterClass.TopologyResponse>)streamObserver));
        this.sendGrpcRequest(request, (StreamObserver<GatewayOuterClass.TopologyResponse>)future);
        return future;
    }

    private void sendGrpcRequest(GatewayOuterClass.TopologyRequest request, StreamObserver<GatewayOuterClass.TopologyResponse> streamObserver) {
        ((GatewayGrpc.GatewayStub)this.asyncStub.withDeadlineAfter(this.requestTimeout.toMillis(), TimeUnit.MILLISECONDS)).topology(request, streamObserver);
    }

    private void sendHttpRequest(HttpCamundaFuture<Topology> result) {
        this.httpClient.get("/topology", this.httpRequestConfig.setResponseTimeout(this.requestTimeout.toMillis(), TimeUnit.MILLISECONDS).build(), TopologyResponse.class, TopologyImpl::new, result);
    }
}

