/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl.command;

import io.camunda.client.api.CamundaFuture;
import io.camunda.client.api.JsonMapper;
import io.camunda.client.api.command.CreateGroupCommandStep1;
import io.camunda.client.api.command.FinalCommandStep;
import io.camunda.client.api.response.CreateGroupResponse;
import io.camunda.client.impl.command.ArgumentUtil;
import io.camunda.client.impl.http.HttpCamundaFuture;
import io.camunda.client.impl.http.HttpClient;
import io.camunda.client.impl.response.CreateGroupResponseImpl;
import io.camunda.client.protocol.rest.GroupCreateRequest;
import io.camunda.client.protocol.rest.GroupCreateResult;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.apache.hc.client5.http.config.RequestConfig;

public class CreateGroupCommandImpl
implements CreateGroupCommandStep1,
CreateGroupCommandStep1.CreateGroupCommandStep2 {
    private final GroupCreateRequest request = new GroupCreateRequest();
    private final JsonMapper jsonMapper;
    private final HttpClient httpClient;
    private final RequestConfig.Builder httpRequestConfig;

    public CreateGroupCommandImpl(HttpClient httpClient, JsonMapper jsonMapper) {
        this.httpClient = httpClient;
        this.jsonMapper = jsonMapper;
        this.httpRequestConfig = httpClient.newRequestConfig();
    }

    @Override
    public CreateGroupCommandStep1.CreateGroupCommandStep2 groupId(String groupId) {
        this.request.setGroupId(groupId);
        return this;
    }

    @Override
    public CreateGroupCommandStep1.CreateGroupCommandStep2 name(String name) {
        this.request.name(name);
        return this;
    }

    @Override
    public CreateGroupCommandStep1.CreateGroupCommandStep2 description(String description) {
        this.request.description(description);
        return this;
    }

    @Override
    public FinalCommandStep<CreateGroupResponse> requestTimeout(Duration requestTimeout) {
        this.httpRequestConfig.setResponseTimeout(requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public CamundaFuture<CreateGroupResponse> send() {
        ArgumentUtil.ensureNotNull("groupId", this.request.getGroupId());
        ArgumentUtil.ensureNotNull("name", this.request.getName());
        HttpCamundaFuture<CreateGroupResponse> result = new HttpCamundaFuture<CreateGroupResponse>();
        CreateGroupResponseImpl response = new CreateGroupResponseImpl();
        this.httpClient.post("/groups", this.jsonMapper.toJson(this.request), this.httpRequestConfig.build(), GroupCreateResult.class, response::setResponse, result);
        return result;
    }
}

