/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl.command;

import io.camunda.client.CamundaClientConfiguration;
import io.camunda.client.api.CamundaFuture;
import io.camunda.client.api.JsonMapper;
import io.camunda.client.api.command.CreateDocumentLinkCommandStep1;
import io.camunda.client.api.command.FinalCommandStep;
import io.camunda.client.api.response.DocumentLinkResponse;
import io.camunda.client.impl.command.ArgumentUtil;
import io.camunda.client.impl.http.HttpCamundaFuture;
import io.camunda.client.impl.http.HttpClient;
import io.camunda.client.impl.response.DocumentLinkResponseImpl;
import io.camunda.client.protocol.rest.DocumentLink;
import io.camunda.client.protocol.rest.DocumentLinkRequest;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.hc.client5.http.config.RequestConfig;

public class CreateDocumentLinkCommandImpl
implements CreateDocumentLinkCommandStep1 {
    final Map<String, String> queryParams;
    final DocumentLinkRequest documentLinkRequest;
    private final String documentId;
    private final HttpClient httpClient;
    private final RequestConfig.Builder httpRequestConfig;
    private final JsonMapper jsonMapper;

    public CreateDocumentLinkCommandImpl(String documentId, String storeId, String contentHash, JsonMapper jsonMapper, HttpClient httpClient, CamundaClientConfiguration configuration) {
        ArgumentUtil.ensureNotNull("documentId", documentId);
        this.documentId = documentId;
        this.queryParams = new HashMap<String, String>();
        if (storeId != null) {
            this.queryParams.put("storeId", storeId);
        }
        this.queryParams.put("contentHash", contentHash);
        this.documentLinkRequest = new DocumentLinkRequest();
        this.jsonMapper = jsonMapper;
        this.httpClient = httpClient;
        this.httpRequestConfig = httpClient.newRequestConfig();
        this.requestTimeout(configuration.getDefaultRequestTimeout());
    }

    @Override
    public CreateDocumentLinkCommandStep1 storeId(String storeId) {
        ArgumentUtil.ensureNotNull("storeId", storeId);
        this.queryParams.put("storeId", storeId);
        return this;
    }

    @Override
    public CreateDocumentLinkCommandStep1 timeToLive(Duration timeToLive) {
        this.documentLinkRequest.setTimeToLive(timeToLive.toMillis());
        return this;
    }

    @Override
    public CreateDocumentLinkCommandStep1 contentHash(String contentHash) {
        this.queryParams.put("contentHash", contentHash);
        return this;
    }

    @Override
    public FinalCommandStep<DocumentLinkResponse> requestTimeout(Duration requestTimeout) {
        this.httpRequestConfig.setResponseTimeout(requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public CamundaFuture<DocumentLinkResponse> send() {
        HttpCamundaFuture<DocumentLinkResponse> result = new HttpCamundaFuture<DocumentLinkResponse>();
        this.httpClient.post(String.format("/documents/%s/links", this.documentId), this.queryParams, this.jsonMapper.toJson(this.documentLinkRequest), this.httpRequestConfig.build(), DocumentLink.class, DocumentLinkResponseImpl::new, result);
        return result;
    }
}

