/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl;

import io.camunda.client.CredentialsProvider;
import io.camunda.client.impl.CamundaClientFutureImpl;
import io.camunda.client.impl.GrpcStatusCode;
import io.grpc.Status;
import io.grpc.stub.StreamObserver;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;

public final class RetriableClientFutureImpl<R, T>
extends CamundaClientFutureImpl<R, T> {
    private final AtomicInteger retries = new AtomicInteger(2);
    private final Predicate<CredentialsProvider.StatusCode> retryPredicate;
    private final Consumer<StreamObserver<T>> retryAction;

    public RetriableClientFutureImpl(Predicate<CredentialsProvider.StatusCode> retryPredicate, Consumer<StreamObserver<T>> retryAction) {
        this(brokerResponse -> null, retryPredicate, retryAction);
    }

    public RetriableClientFutureImpl(Function<T, R> responseMapper, Predicate<CredentialsProvider.StatusCode> retryPredicate, Consumer<StreamObserver<T>> retryAction) {
        super(responseMapper);
        Objects.requireNonNull(retryPredicate, "Expected to have non-null retry predicate.");
        Objects.requireNonNull(retryAction, "Expected to have non-null retry action.");
        this.retryPredicate = retryPredicate;
        this.retryAction = retryAction;
    }

    @Override
    public void onError(Throwable throwable) {
        Status status = Status.fromThrowable((Throwable)throwable);
        GrpcStatusCode statusCode = new GrpcStatusCode(status.getCode());
        if (this.retries.getAndDecrement() > 0 && this.retryPredicate.test(statusCode)) {
            this.retryAction.accept((StreamObserver<RetriableClientFutureImpl>)this);
        } else {
            super.onError(throwable);
        }
    }
}

