/*
 * Decompiled with CFR 0.152.
 */
package io.burt.jmespath.jackson;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.burt.jmespath.BaseRuntime;
import io.burt.jmespath.JmesPathType;
import io.burt.jmespath.function.FunctionRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class JacksonRuntime
extends BaseRuntime<JsonNode> {
    private final ObjectMapper jsonParser = new ObjectMapper();

    public JacksonRuntime() {
        this(null);
    }

    public JacksonRuntime(FunctionRegistry functionRegistry) {
        super(functionRegistry);
    }

    public JsonNode parseString(String string) {
        try {
            return this.jsonParser.readTree(string);
        }
        catch (IOException ioe) {
            throw new IllegalStateException(ioe);
        }
    }

    public List<JsonNode> toList(JsonNode value) {
        if (value.isArray() || value.isObject()) {
            ArrayList<JsonNode> elements = new ArrayList<JsonNode>(value.size());
            for (JsonNode element : value) {
                elements.add(element);
            }
            return elements;
        }
        return Collections.emptyList();
    }

    public String toString(JsonNode str) {
        if (str.isTextual()) {
            return str.textValue();
        }
        return str.toString();
    }

    public Number toNumber(JsonNode n) {
        return n.numberValue();
    }

    public boolean isTruthy(JsonNode value) {
        switch (value.getNodeType()) {
            case ARRAY: 
            case BINARY: 
            case OBJECT: {
                return value.size() > 0;
            }
            case STRING: {
                return value.textValue().length() > 0;
            }
            case BOOLEAN: {
                return value.booleanValue();
            }
            case MISSING: 
            case NULL: {
                return false;
            }
            case NUMBER: 
            case POJO: {
                return true;
            }
        }
        throw new IllegalStateException(String.format("Unknown node type encountered: %s", value.getNodeType()));
    }

    public JmesPathType typeOf(JsonNode value) {
        switch (value.getNodeType()) {
            case ARRAY: {
                return JmesPathType.ARRAY;
            }
            case OBJECT: 
            case POJO: {
                return JmesPathType.OBJECT;
            }
            case BINARY: 
            case STRING: {
                return JmesPathType.STRING;
            }
            case BOOLEAN: {
                return JmesPathType.BOOLEAN;
            }
            case MISSING: 
            case NULL: {
                return JmesPathType.NULL;
            }
            case NUMBER: {
                return JmesPathType.NUMBER;
            }
        }
        throw new IllegalStateException(String.format("Unknown node type encountered: %s", value.getNodeType()));
    }

    public JsonNode getProperty(JsonNode value, String name) {
        return this.nodeOrNullNode(value.get(name));
    }

    public JsonNode getProperty(JsonNode value, JsonNode name) {
        return this.getProperty(value, name.textValue());
    }

    public Collection<JsonNode> getPropertyNames(JsonNode value) {
        if (value.isObject()) {
            ArrayList<JsonNode> names = new ArrayList<JsonNode>(value.size());
            Iterator fieldNames = value.fieldNames();
            while (fieldNames.hasNext()) {
                names.add(this.createString((String)fieldNames.next()));
            }
            return names;
        }
        return Collections.emptyList();
    }

    public JsonNode createNull() {
        return this.nodeOrNullNode(null);
    }

    public JsonNode createArray(Collection<JsonNode> elements) {
        ArrayNode array = JsonNodeFactory.instance.arrayNode();
        array.addAll(elements);
        return array;
    }

    public JsonNode createString(String str) {
        return JsonNodeFactory.instance.textNode(str);
    }

    public JsonNode createBoolean(boolean b) {
        return JsonNodeFactory.instance.booleanNode(b);
    }

    public JsonNode createObject(Map<JsonNode, JsonNode> obj) {
        ObjectNode object = new ObjectNode(JsonNodeFactory.instance);
        for (Map.Entry<JsonNode, JsonNode> entry : obj.entrySet()) {
            object.set(entry.getKey().textValue(), entry.getValue());
        }
        return object;
    }

    public JsonNode createNumber(double n) {
        return JsonNodeFactory.instance.numberNode(n);
    }

    public JsonNode createNumber(long n) {
        return JsonNodeFactory.instance.numberNode(n);
    }

    private JsonNode nodeOrNullNode(JsonNode node) {
        if (node == null) {
            return JsonNodeFactory.instance.nullNode();
        }
        return node;
    }
}

