/*
 * Decompiled with CFR 0.152.
 */
package io.burt.jmespath.gson;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import io.burt.jmespath.BaseRuntime;
import io.burt.jmespath.JmesPathType;
import io.burt.jmespath.RuntimeConfiguration;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class GsonRuntime
extends BaseRuntime<JsonElement> {
    private final JsonParser parser = new JsonParser();

    public GsonRuntime() {
        this(RuntimeConfiguration.defaultConfiguration());
    }

    public GsonRuntime(RuntimeConfiguration configuration) {
        super(configuration);
    }

    public JsonElement parseString(String str) {
        return this.parser.parse(str);
    }

    public List<JsonElement> toList(JsonElement value) {
        if (value.isJsonArray()) {
            return new JsonArrayListWrapper(value.getAsJsonArray());
        }
        if (value.isJsonObject()) {
            JsonObject object = value.getAsJsonObject();
            ArrayList<JsonElement> list = new ArrayList<JsonElement>(object.size());
            for (Map.Entry entry : object.entrySet()) {
                list.add((JsonElement)entry.getValue());
            }
            return list;
        }
        return Collections.emptyList();
    }

    public String toString(JsonElement value) {
        if (value.isJsonPrimitive() && value.getAsJsonPrimitive().isString()) {
            return value.getAsJsonPrimitive().getAsString();
        }
        return value.toString();
    }

    public Number toNumber(JsonElement value) {
        return value.isJsonPrimitive() && value.getAsJsonPrimitive().isNumber() ? (Number)value.getAsNumber() : (Number)null;
    }

    public boolean isTruthy(JsonElement value) {
        switch (this.typeOf(value)) {
            case NULL: {
                return false;
            }
            case BOOLEAN: {
                return value.getAsBoolean();
            }
            case STRING: {
                return !value.getAsString().isEmpty();
            }
            case NUMBER: {
                return true;
            }
            case ARRAY: {
                return !value.getAsJsonArray().isEmpty();
            }
            case OBJECT: {
                return !value.getAsJsonObject().isEmpty();
            }
        }
        throw new IllegalStateException(String.format("Unknown node type encountered: %s", value.getClass()));
    }

    public JmesPathType typeOf(JsonElement value) {
        if (value.isJsonArray()) {
            return JmesPathType.ARRAY;
        }
        if (value.isJsonObject()) {
            return JmesPathType.OBJECT;
        }
        if (value.isJsonPrimitive()) {
            if (value.getAsJsonPrimitive().isBoolean()) {
                return JmesPathType.BOOLEAN;
            }
            if (value.getAsJsonPrimitive().isNumber()) {
                return JmesPathType.NUMBER;
            }
            if (value.getAsJsonPrimitive().isString()) {
                return JmesPathType.STRING;
            }
        } else if (value.isJsonNull()) {
            return JmesPathType.NULL;
        }
        throw new IllegalStateException(String.format("Unknown node type encountered: %s", value.getClass()));
    }

    public JsonElement getProperty(JsonElement value, JsonElement name) {
        return this.nodeOrNullNode(value.isJsonObject() ? value.getAsJsonObject().get(name.getAsString()) : null);
    }

    public Collection<JsonElement> getPropertyNames(JsonElement value) {
        if (value.isJsonObject()) {
            JsonObject object = (JsonObject)value;
            ArrayList<JsonElement> names = new ArrayList<JsonElement>(object.size());
            for (String s : object.keySet()) {
                names.add(this.createString(s));
            }
            return names;
        }
        return Collections.emptyList();
    }

    public JsonElement createNull() {
        return JsonNull.INSTANCE;
    }

    public JsonElement createArray(Collection<JsonElement> elements) {
        JsonArray array = new JsonArray();
        for (JsonElement e : elements) {
            array.add(e);
        }
        return array;
    }

    public JsonElement createString(String str) {
        return new JsonPrimitive(str);
    }

    public JsonElement createBoolean(boolean b) {
        return new JsonPrimitive(Boolean.valueOf(b));
    }

    public JsonElement createObject(Map<JsonElement, JsonElement> obj) {
        JsonObject object = new JsonObject();
        for (Map.Entry<JsonElement, JsonElement> entry : obj.entrySet()) {
            object.add(entry.getKey().getAsString(), entry.getValue());
        }
        return object;
    }

    public JsonElement createNumber(double n) {
        return new JsonPrimitive((Number)n);
    }

    public JsonElement createNumber(long n) {
        return new JsonPrimitive((Number)n);
    }

    private JsonElement nodeOrNullNode(JsonElement node) {
        if (node == null) {
            return JsonNull.INSTANCE;
        }
        return node;
    }

    private static class JsonArrayListWrapper
    extends AbstractList<JsonElement> {
        private final JsonArray array;

        JsonArrayListWrapper(JsonArray array) {
            this.array = array;
        }

        @Override
        public JsonElement get(int index) {
            return this.array.get(index);
        }

        @Override
        public int size() {
            return this.array.size();
        }
    }
}

