/*
 * Decompiled with CFR 0.152.
 */
package io.burt.jmespath.function;

import io.burt.jmespath.Adapter;
import io.burt.jmespath.function.ArgumentConstraint;
import io.burt.jmespath.function.ArgumentConstraints;
import io.burt.jmespath.function.ArgumentTypeException;
import io.burt.jmespath.function.ArityException;
import io.burt.jmespath.function.Function;
import io.burt.jmespath.function.FunctionArgument;
import io.burt.jmespath.function.FunctionConfigurationException;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class BaseFunction
implements Function {
    private final ArgumentConstraint argumentConstraints;
    private final String name;
    private static final Pattern CAMEL_CASE_COMPONENT_RE = Pattern.compile("[A-Z][^A-Z]+");

    public BaseFunction(ArgumentConstraint argumentConstraints) {
        this((String)null, argumentConstraints);
    }

    public BaseFunction(ArgumentConstraint ... argumentConstraints) {
        this((String)null, ArgumentConstraints.listOf(argumentConstraints));
    }

    public BaseFunction(String name, ArgumentConstraint ... argumentConstraints) {
        this(name, ArgumentConstraints.listOf(argumentConstraints));
    }

    public BaseFunction(String name, ArgumentConstraint argumentConstraints) {
        this.name = name == null ? this.classNameToFunctionName() : name;
        this.argumentConstraints = argumentConstraints;
    }

    private String classNameToFunctionName() {
        String piece;
        String n = this.getClass().getName();
        n = n.indexOf(36) > -1 ? n.substring(n.lastIndexOf(36) + 1) : n.substring(n.lastIndexOf(46) + 1);
        if (!n.endsWith("Function")) {
            throw new FunctionConfigurationException(String.format("The function defined by %s must either pass a name to the Function constructor or the class name must end with \"Function\"", this.getClass().getName()));
        }
        Matcher m = CAMEL_CASE_COMPONENT_RE.matcher(n);
        int offset = 0;
        StringBuilder snakeCaseName = new StringBuilder();
        while (m.find(offset) && !(piece = n.substring(m.start(), m.end()).toLowerCase()).equals("function")) {
            snakeCaseName.append(piece);
            snakeCaseName.append('_');
            offset = m.end();
        }
        snakeCaseName.deleteCharAt(snakeCaseName.length() - 1);
        return snakeCaseName.toString();
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public ArgumentConstraint argumentConstraints() {
        return this.argumentConstraints;
    }

    @Override
    public <T> T call(Adapter<T> runtime, List<FunctionArgument<T>> arguments) {
        this.checkArguments(runtime, arguments);
        return this.callFunction(runtime, arguments);
    }

    protected <T> void checkArguments(Adapter<T> runtime, List<FunctionArgument<T>> arguments) {
        try {
            Iterator<FunctionArgument<T>> argumentIterator = arguments.iterator();
            this.argumentConstraints.check(runtime, argumentIterator);
            if (argumentIterator.hasNext()) {
                throw new ArityException(this, arguments.size());
            }
        }
        catch (ArgumentConstraints.InternalArityException e) {
            throw new ArityException(this, arguments.size(), e);
        }
        catch (ArgumentConstraints.InternalArgumentTypeException e) {
            throw new ArgumentTypeException(this.name(), e.expectedType(), e.actualType(), e);
        }
    }

    protected abstract <T> T callFunction(Adapter<T> var1, List<FunctionArgument<T>> var2);
}

