/*
 * Decompiled with CFR 0.152.
 */
package io.jafar.parser.internal_api;

import io.jafar.parser.ParsingUtils;
import io.jafar.parser.internal_api.RecordingStream;
import io.jafar.parser.internal_api.TypeSkipper;
import java.lang.invoke.MethodHandle;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public abstract class Deserializer<T> {
    private static final Deserializer<?> NONE = new Deserializer(){

        @Override
        public void skip(RecordingStream stream) throws Exception {
        }

        public Object deserialize(RecordingStream stream) throws Exception {
            return null;
        }
    };
    private static final Deserializer<String> UTF8_STRING = new Deserializer<String>(){

        @Override
        public void skip(RecordingStream stream) throws Exception {
            ParsingUtils.skipUTF8(stream);
        }

        @Override
        public String deserialize(RecordingStream stream) throws Exception {
            return stream.readUTF8();
        }
    };
    private static final Deserializer<?> VARINT = new Deserializer<Object>(){

        @Override
        public void skip(RecordingStream stream) throws Exception {
            stream.readVarint();
        }

        @Override
        public Object deserialize(RecordingStream stream) throws Exception {
            throw new UnsupportedOperationException();
        }
    };
    private static final Deserializer<?> FLOAT = new Deserializer<Object>(){

        @Override
        public void skip(RecordingStream stream) throws Exception {
            stream.readFloat();
        }

        @Override
        public Object deserialize(RecordingStream stream) throws Exception {
            throw new UnsupportedOperationException();
        }
    };
    private static final Deserializer<?> DOUBLE = new Deserializer<Object>(){

        @Override
        public void skip(RecordingStream stream) throws Exception {
            stream.readDouble();
        }

        @Override
        public Object deserialize(RecordingStream stream) throws Exception {
            throw new UnsupportedOperationException();
        }
    };
    private static final Deserializer<?> BYTE = new Deserializer<Object>(){

        @Override
        public void skip(RecordingStream stream) throws Exception {
            stream.read();
        }

        @Override
        public Object deserialize(RecordingStream stream) throws Exception {
            throw new UnsupportedOperationException();
        }
    };
    private static final Map<String, Deserializer<?>> DESERIALIZERS;

    public static <T> Deserializer<T> none() {
        return NONE;
    }

    protected Deserializer() {
    }

    public static Deserializer<?> forPrimitive(String typeName) {
        return DESERIALIZERS.get(typeName);
    }

    public abstract void skip(RecordingStream var1) throws Exception;

    public abstract T deserialize(RecordingStream var1) throws Exception;

    static {
        HashMap m = new HashMap();
        m.put("java.lang.String", UTF8_STRING);
        m.put("short", VARINT);
        m.put("char", VARINT);
        m.put("int", VARINT);
        m.put("long", VARINT);
        m.put("double", DOUBLE);
        m.put("float", FLOAT);
        m.put("byte", BYTE);
        m.put("boolean", BYTE);
        DESERIALIZERS = Collections.unmodifiableMap(m);
    }

    public static final class Generated<T>
    extends Deserializer<T> {
        private final MethodHandle factoryHandle;
        private final MethodHandle skipHandler;
        private final TypeSkipper typeSkipper;

        public Generated(MethodHandle factoryHandle, MethodHandle skipHandler, TypeSkipper skipper) {
            this.factoryHandle = factoryHandle;
            this.skipHandler = skipHandler;
            this.typeSkipper = skipper;
        }

        @Override
        public void skip(RecordingStream stream) throws Exception {
            if (this.typeSkipper != null) {
                this.typeSkipper.skip(stream);
            } else if (this.skipHandler != null) {
                try {
                    this.skipHandler.invokeExact(stream);
                }
                catch (Throwable t) {
                    throw new RuntimeException(t);
                }
            } else {
                throw new RuntimeException("Unsupported skip handler type");
            }
        }

        @Override
        public T deserialize(RecordingStream stream) throws Exception {
            try {
                if (this.factoryHandle == null) {
                    this.skip(stream);
                    return null;
                }
                return (T)this.factoryHandle.invoke(stream);
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }
    }
}

