/*
 * Decompiled with CFR 0.152.
 */
package io.jafar.parser.impl;

import io.jafar.parser.api.ArrayType;
import java.lang.reflect.Array;
import java.util.Arrays;

public final class ArrayHolder
implements ArrayType {
    private final String type;
    private final Object array;
    private int index = 0;

    ArrayHolder(String type, int len) {
        this.type = type;
        switch (type) {
            case "short": {
                this.array = new short[len];
                break;
            }
            case "char": {
                this.array = new char[len];
                break;
            }
            case "int": {
                this.array = new int[len];
                break;
            }
            case "long": {
                this.array = new long[len];
                break;
            }
            case "byte": {
                this.array = new byte[len];
                break;
            }
            case "boolean": {
                this.array = new boolean[len];
                break;
            }
            case "double": {
                this.array = new double[len];
                break;
            }
            case "float": {
                this.array = new float[len];
                break;
            }
            default: {
                this.array = new Object[len];
            }
        }
    }

    void add(Object value) {
        Array.set(this.array, this.index++, value);
    }

    @Override
    public Object getArray() {
        return this.array;
    }

    @Override
    public Class<?> getType() {
        return this.array.getClass();
    }

    public String toString() {
        switch (this.type) {
            case "short": {
                return Arrays.toString((short[])this.array);
            }
            case "char": {
                return Arrays.toString((char[])this.array);
            }
            case "int": {
                return Arrays.toString((int[])this.array);
            }
            case "long": {
                return Arrays.toString((long[])this.array);
            }
            case "byte": {
                return Arrays.toString((byte[])this.array);
            }
            case "boolean": {
                return Arrays.toString((boolean[])this.array);
            }
            case "double": {
                return Arrays.toString((double[])this.array);
            }
            case "float": {
                return Arrays.toString((float[])this.array);
            }
        }
        return Arrays.toString((Object[])this.array);
    }
}

