/*
 * Decompiled with CFR 0.152.
 */
package io.jafar.utils;

import java.nio.charset.Charset;
import java.util.Arrays;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class CachedStringParser {
    public static ByteArrayParser byteParser() {
        return new ByteArrayParser();
    }

    public static CharArrayParser charParser() {
        return new CharArrayParser();
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static final class CharArrayParser {
        private char[] previousData = new char[4096];
        private int previousLen = 0;
        private String lastString = null;

        public String parse(char[] data, int len) {
            if (this.lastString != null && this.previousLen == len && CharArrayParser.equalsRange(data, this.previousData, len)) {
                return this.lastString;
            }
            if (len > this.previousData.length) {
                this.previousData = Arrays.copyOf(data, len);
            } else {
                System.arraycopy(data, 0, this.previousData, 0, len);
            }
            this.previousLen = len;
            this.lastString = new String(data, 0, len);
            return this.lastString;
        }

        private static boolean equalsRange(char[] a, char[] b, int len) {
            if (a == b) {
                return true;
            }
            if (a == null || b == null) {
                return false;
            }
            if (a.length < len || b.length < len) {
                return false;
            }
            for (int i = 0; i < len; ++i) {
                if (a[i] == b[i]) continue;
                return false;
            }
            return true;
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static final class ByteArrayParser {
        private byte[] previousData = new byte[4096];
        private int previousLen = 0;
        private String lastString = null;

        public String parse(byte[] data, int len, Charset charset) {
            if (this.lastString != null && this.previousLen == len && ByteArrayParser.equalsRange(data, this.previousData, len)) {
                return this.lastString;
            }
            if (len > this.previousData.length) {
                this.previousData = Arrays.copyOf(data, len);
            } else {
                System.arraycopy(data, 0, this.previousData, 0, len);
            }
            this.previousLen = len;
            this.lastString = new String(data, 0, len, charset);
            return this.lastString;
        }

        private static boolean equalsRange(byte[] a, byte[] b, int len) {
            if (a == b) {
                return true;
            }
            if (a == null || b == null) {
                return false;
            }
            if (a.length < len || b.length < len) {
                return false;
            }
            for (int i = 0; i < len; ++i) {
                if (a[i] == b[i]) continue;
                return false;
            }
            return true;
        }
    }
}

