/*
 * Decompiled with CFR 0.152.
 */
package io.jafar.parser.internal_api.metadata;

import io.jafar.parser.internal_api.MutableMetadataLookup;
import io.jafar.parser.internal_api.metadata.AbstractMetadataElement;
import io.jafar.parser.internal_api.metadata.MetadataClass;
import io.jafar.parser.internal_api.metadata.MetadataField;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;

public final class MetadataFingerprint {
    private final byte[] hash;

    private MetadataFingerprint(byte[] hash) {
        this.hash = hash;
    }

    public static MetadataFingerprint compute(MutableMetadataLookup metadata, Set<Long> reachableClassIds) {
        try {
            ByteBuffer buffer = ByteBuffer.allocate(8192);
            ArrayList<MetadataClass> classes = new ArrayList<MetadataClass>();
            for (long classId : reachableClassIds) {
                MetadataClass clz = metadata.getClass(classId);
                if (clz == null) continue;
                classes.add(clz);
            }
            classes.sort(Comparator.comparingLong(AbstractMetadataElement::getId));
            for (MetadataClass clz : classes) {
                buffer = MetadataFingerprint.ensureCapacity(buffer, 1024);
                buffer.putLong(clz.getId());
                MetadataFingerprint.writeString(buffer, clz.getName());
                MetadataFingerprint.writeString(buffer, clz.getSuperType());
                buffer.putInt(clz.getFields().size());
                for (MetadataField field : clz.getFields()) {
                    buffer = MetadataFingerprint.ensureCapacity(buffer, 256);
                    buffer.putLong(field.getType().getId());
                    MetadataFingerprint.writeString(buffer, field.getName());
                    buffer.put((byte)(field.hasConstantPool() ? 1 : 0));
                    buffer.putInt(field.getDimension());
                }
            }
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            md.update(buffer.array(), 0, buffer.position());
            byte[] hash = md.digest();
            return new MetadataFingerprint(hash);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("SHA-256 algorithm not available", e);
        }
    }

    public static Set<Long> computeReachableTypes(MutableMetadataLookup metadata, Set<String> eventTypeNames) {
        MetadataClass clz;
        HashSet<Long> reachable = new HashSet<Long>();
        LinkedList<Long> queue = new LinkedList<Long>();
        for (String eventName : eventTypeNames) {
            clz = metadata.getClass(eventName);
            if (clz == null) continue;
            queue.add(clz.getId());
            reachable.add(clz.getId());
        }
        while (!queue.isEmpty()) {
            long classId = (Long)queue.poll();
            clz = metadata.getClass(classId);
            if (clz == null) continue;
            for (MetadataField field : clz.getFields()) {
                long fieldTypeId = field.getType().getId();
                if (!reachable.add(fieldTypeId)) continue;
                queue.add(fieldTypeId);
            }
        }
        return reachable;
    }

    private static void writeString(ByteBuffer buffer, String str) {
        if (str == null) {
            buffer.putInt(-1);
        } else {
            byte[] bytes = str.getBytes(StandardCharsets.UTF_8);
            buffer.putInt(bytes.length);
            buffer.put(bytes);
        }
    }

    private static ByteBuffer ensureCapacity(ByteBuffer buffer, int additional) {
        if (buffer.remaining() < additional) {
            ByteBuffer newBuffer = ByteBuffer.allocate(buffer.capacity() * 2);
            buffer.flip();
            newBuffer.put(buffer);
            return newBuffer;
        }
        return buffer;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetadataFingerprint that = (MetadataFingerprint)o;
        return Arrays.equals(this.hash, that.hash);
    }

    public int hashCode() {
        return Arrays.hashCode(this.hash);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("MetadataFingerprint[");
        for (byte b : this.hash) {
            sb.append(String.format("%02x", b));
        }
        sb.append("]");
        return sb.toString();
    }

    public byte[] getHashBytes() {
        return Arrays.copyOf(this.hash, this.hash.length);
    }
}

