/*
 * Decompiled with CFR 0.152.
 */
package io.jafar.parser.internal_api.metadata;

import io.jafar.parser.AbstractEvent;
import io.jafar.parser.internal_api.MutableMetadataLookup;
import io.jafar.parser.internal_api.RecordingStream;
import io.jafar.parser.internal_api.metadata.AbstractMetadataElement;
import io.jafar.parser.internal_api.metadata.MetadataAnnotation;
import io.jafar.parser.internal_api.metadata.MetadataClass;
import io.jafar.parser.internal_api.metadata.MetadataElement;
import io.jafar.parser.internal_api.metadata.MetadataField;
import io.jafar.parser.internal_api.metadata.MetadataRegion;
import io.jafar.parser.internal_api.metadata.MetadataRoot;
import io.jafar.parser.internal_api.metadata.MetadataSetting;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public final class MetadataEvent
extends AbstractEvent {
    private boolean hasHashCode = false;
    private int hashCode;
    public final int size;
    public final long startTime;
    public final long duration;
    public final long metadataId;
    private final MetadataRoot root;
    private final List<MetadataClass> classes = new ArrayList<MetadataClass>(200);
    private final boolean forceConstantPools;

    public MetadataEvent(RecordingStream stream, boolean forceConstantPools) throws IOException {
        super(stream);
        this.size = (int)stream.readVarint();
        if (this.size == 0) {
            throw new IOException("Unexpected event size. Should be > 0");
        }
        long typeId = stream.readVarint();
        if (typeId != 0L) {
            throw new IOException("Unexpected event type: " + typeId + " (should be 0)");
        }
        this.startTime = stream.readVarint();
        this.duration = stream.readVarint();
        this.metadataId = stream.readVarint();
        this.forceConstantPools = forceConstantPools;
        this.readStringTable(stream);
        this.root = (MetadataRoot)this.readElement(stream);
    }

    private void readStringTable(RecordingStream stream) throws IOException {
        int stringCnt = (int)stream.readVarint();
        String[] stringConstants = new String[stringCnt];
        for (int stringIdx = 0; stringIdx < stringCnt; ++stringIdx) {
            stringConstants[stringIdx] = stream.readUTF8();
        }
        ((MutableMetadataLookup)stream.getContext().getMetadataLookup()).setStringtable(stringConstants);
    }

    AbstractMetadataElement readElement(RecordingStream stream) throws IOException {
        try {
            int stringPtr = (int)stream.readVarint();
            String typeId = stream.getContext().getMetadataLookup().getString(stringPtr);
            AbstractMetadataElement element = null;
            switch (typeId) {
                case "class": {
                    MetadataClass clz = new MetadataClass(stream, this);
                    this.classes.add(clz);
                    element = clz;
                    break;
                }
                case "field": {
                    element = new MetadataField(stream, this, this.forceConstantPools);
                    break;
                }
                case "annotation": {
                    element = new MetadataAnnotation(stream, this);
                    break;
                }
                case "root": {
                    element = new MetadataRoot(stream, this);
                    break;
                }
                case "metadata": {
                    element = new MetadataElement(stream, this);
                    break;
                }
                case "region": {
                    element = new MetadataRegion(stream, this);
                    break;
                }
                case "setting": {
                    element = new MetadataSetting(stream, this);
                    break;
                }
                default: {
                    throw new IOException("Unsupported metadata type: " + typeId);
                }
            }
            return element;
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw t;
        }
    }

    public MetadataRoot getRoot() {
        return this.root;
    }

    public Collection<MetadataClass> getClasses() {
        return Collections.unmodifiableCollection(this.classes);
    }

    public String toString() {
        return "Metadata{size=" + this.size + ", startTime=" + this.startTime + ", duration=" + this.duration + ", metadataId=" + this.metadataId + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetadataEvent that = (MetadataEvent)o;
        return this.size == that.size && this.startTime == that.startTime && this.duration == that.duration && this.metadataId == that.metadataId && this.forceConstantPools == that.forceConstantPools && Objects.equals(this.root, that.root) && Objects.equals(this.classes, that.classes);
    }

    public int hashCode() {
        if (!this.hasHashCode) {
            this.hashCode = Objects.hash(this.size, this.startTime, this.duration, this.metadataId, this.root, this.classes, this.forceConstantPools);
            this.hasHashCode = true;
        }
        return this.hashCode;
    }
}

