/*
 * Decompiled with CFR 0.152.
 */
package io.jafar.parser.internal_api.metadata;

import io.jafar.parser.api.ConstantPools;
import io.jafar.parser.api.HandlerFactory;
import io.jafar.parser.impl.TypedParserContext;
import io.jafar.parser.internal_api.Deserializer;
import io.jafar.parser.internal_api.DeserializerCache;
import io.jafar.parser.internal_api.DeserializerFactory;
import io.jafar.parser.internal_api.RecordingStream;
import io.jafar.parser.internal_api.TypeSkipper;
import io.jafar.parser.internal_api.metadata.AbstractMetadataElement;
import io.jafar.parser.internal_api.metadata.MetadataAnnotation;
import io.jafar.parser.internal_api.metadata.MetadataElementKind;
import io.jafar.parser.internal_api.metadata.MetadataEvent;
import io.jafar.parser.internal_api.metadata.MetadataField;
import io.jafar.parser.internal_api.metadata.MetadataSetting;
import io.jafar.parser.internal_api.metadata.MetadataVisitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

public final class MetadataClass
extends AbstractMetadataElement {
    private boolean hasHashCode = false;
    private int hashCode;
    private static final Set<String> primitiveTypeNames = new HashSet<String>(Arrays.asList("byte", "char", "short", "int", "long", "float", "double", "boolean", "java.lang.String"));
    private Map<String, MetadataSetting> settings = null;
    private List<MetadataAnnotation> annotations = null;
    private List<MetadataField> fields = null;
    private String superType;
    private Boolean isPrimitive;
    private Boolean isSimpleType;
    private String simpleTypeVal;
    private final int associatedChunk;
    private static final AtomicReferenceFieldUpdater<MetadataClass, Deserializer> DESERIALIZER_UPDATER = AtomicReferenceFieldUpdater.newUpdater(MetadataClass.class, Deserializer.class, "deserializer");
    private static final AtomicReferenceFieldUpdater<MetadataClass, TypeSkipper> TYPE_SKIPPER_UPDATER = AtomicReferenceFieldUpdater.newUpdater(MetadataClass.class, TypeSkipper.class, "typeSkipper");
    private volatile Deserializer<?> deserializer;
    private volatile TypeSkipper typeSkipper;
    private volatile HandlerFactory<?> factory;
    private static final AtomicReferenceFieldUpdater<MetadataClass, HandlerFactory> FACTORY_UPDATER = AtomicReferenceFieldUpdater.newUpdater(MetadataClass.class, HandlerFactory.class, "factory");

    MetadataClass(RecordingStream stream, MetadataEvent eventr) throws IOException {
        super(stream, MetadataElementKind.CLASS);
        this.associatedChunk = stream.getContext().getChunkIndex();
        this.readSubelements(eventr);
        this.metadataLookup.addClass(this.getId(), this);
    }

    @Override
    protected void onAttribute(String key, String value) {
        if (key.equals("superType")) {
            this.superType = value;
        } else if (key.equals("simpleType")) {
            this.simpleTypeVal = value;
        }
    }

    public void bindDeserializer() {
        DESERIALIZER_UPDATER.updateAndGet(this, v -> {
            if (v != null) {
                return v;
            }
            DeserializerFactory factory = this.getContext().get(DeserializerFactory.class);
            if (factory == null) {
                return Deserializer.none();
            }
            DeserializerCache cache = this.getContext().get(DeserializerCache.class);
            if (cache == null) {
                return Deserializer.none();
            }
            Class<?> targetClass = null;
            if (this.getContext() instanceof TypedParserContext) {
                targetClass = ((TypedParserContext)this.getContext()).getClassTargetType(this.getName());
            }
            return cache.computeIfAbsent(new TypedParserContext.DeserializerKey(this, targetClass), k -> factory.create(this));
        });
    }

    public void bindFactory(HandlerFactory<?> handlerFactory) {
        FACTORY_UPDATER.set(this, handlerFactory);
    }

    public HandlerFactory<?> getFactory() {
        return this.factory;
    }

    public Deserializer<?> getDeserializer() {
        Deserializer<?> ret = this.deserializer;
        if (ret == null) {
            this.bindDeserializer();
            ret = this.deserializer;
        }
        return ret == Deserializer.none() ? null : ret;
    }

    public String getSuperType() {
        return this.superType;
    }

    public boolean isPrimitive() {
        if (this.isPrimitive == null) {
            this.isPrimitive = primitiveTypeNames.contains(this.getName());
        }
        return this.isPrimitive;
    }

    public boolean isSimpleType() {
        if (this.isSimpleType == null) {
            this.isSimpleType = Boolean.parseBoolean(this.simpleTypeVal);
        }
        return this.isSimpleType;
    }

    @Override
    protected void onSubelement(int count, AbstractMetadataElement element) {
        if (element.getKind() == MetadataElementKind.SETTING) {
            if (this.settings == null) {
                this.settings = new HashMap<String, MetadataSetting>(count * 2, 0.5f);
            }
            MetadataSetting setting = (MetadataSetting)element;
            this.settings.put(setting.getName(), setting);
        } else if (element.getKind() == MetadataElementKind.ANNOTATION) {
            if (this.annotations == null) {
                this.annotations = new ArrayList<MetadataAnnotation>(count);
            }
            this.annotations.add((MetadataAnnotation)element);
        } else if (element.getKind() == MetadataElementKind.FIELD) {
            if (this.fields == null) {
                this.fields = new ArrayList<MetadataField>(count);
            }
            MetadataField field = (MetadataField)element;
            this.fields.add(field);
        } else {
            throw new IllegalStateException("Unexpected subelement: " + (Object)((Object)element.getKind()));
        }
    }

    @Override
    public void accept(MetadataVisitor visitor) {
        visitor.visitClass(this);
        if (this.settings != null) {
            this.settings.values().forEach(s -> s.accept(visitor));
        }
        if (this.annotations != null) {
            this.annotations.forEach(a -> a.accept(visitor));
        }
        if (this.fields != null) {
            this.fields.forEach(f -> f.accept(visitor));
        }
        visitor.visitEnd(this);
    }

    public List<MetadataField> getFields() {
        return Collections.unmodifiableList(this.fields == null ? Collections.emptyList() : this.fields);
    }

    public List<MetadataAnnotation> getAnnotations() {
        return Collections.unmodifiableList(this.annotations == null ? Collections.emptyList() : this.annotations);
    }

    public Map<String, Map<String, Object>> getSettingsByName() {
        if (this.settings == null || this.settings.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap out = new HashMap(this.settings.size());
        for (Map.Entry<String, MetadataSetting> e : this.settings.entrySet()) {
            MetadataSetting s = e.getValue();
            HashMap<String, String> m = new HashMap<String, String>();
            m.put("type", s.getType() != null ? s.getType().getName() : null);
            m.put("defaultValue", s.getValue());
            out.put(e.getKey(), m);
        }
        return Collections.unmodifiableMap(out);
    }

    public void skip(RecordingStream stream) throws IOException {
        Deserializer<?> d = this.getDeserializer();
        if (d == null) {
            this.skipDirect(stream);
        } else {
            try {
                d.skip(stream);
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
    }

    public void skipDirect(RecordingStream stream) throws IOException {
        TypeSkipper skipper = TYPE_SKIPPER_UPDATER.updateAndGet(this, ts -> ts == null ? TypeSkipper.createSkipper(this) : ts);
        skipper.skip(stream);
    }

    public <T> T read(RecordingStream stream) {
        HandlerFactory<?> f = this.factory;
        if (f != null) {
            try {
                ConstantPools constantPools = this.getContext().getConstantPools();
                return (T)f.get(stream, this, constantPools);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        Deserializer<?> d = this.getDeserializer();
        if (d == null) {
            return null;
        }
        try {
            return (T)d.deserialize(stream);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean isPrimitive(String typeName) {
        return typeName.equals("byte") || typeName.equals("short") || typeName.equals("char") || typeName.equals("int") || typeName.equals("long") || typeName.equals("float") || typeName.equals("double") || typeName.equals("boolean") || typeName.equals("java.lang.String");
    }

    public String toString() {
        return "MetadataClass{id='" + this.getId() + '\'' + ", chunk=" + this.associatedChunk + ", name='" + this.getName() + "', superType='" + this.superType + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetadataClass that = (MetadataClass)o;
        return this.getId() == that.getId() && Objects.equals(this.getName(), that.getName()) && Objects.equals(this.superType, that.superType) && Objects.equals(this.fields, that.fields);
    }

    public int hashCode() {
        if (!this.hasHashCode) {
            long mixed = this.getId() * -7046029254386353131L + (long)this.getName().hashCode() * -4126379630918253789L + (long)Objects.hashCode(this.superType) * -2876049455945701127L + (long)Objects.hashCode(this.fields) * -6651371118538410227L;
            this.hashCode = Long.hashCode(mixed);
            this.hasHashCode = true;
        }
        return this.hashCode;
    }
}

