/*
 * Decompiled with CFR 0.152.
 */
package io.jafar.parser.internal_api.metadata;

import io.jafar.parser.ParsingUtils;
import io.jafar.parser.api.ParserContext;
import io.jafar.parser.internal_api.MutableMetadataLookup;
import io.jafar.parser.internal_api.RecordingStream;
import io.jafar.parser.internal_api.metadata.MetadataElementKind;
import io.jafar.parser.internal_api.metadata.MetadataEvent;
import io.jafar.parser.internal_api.metadata.MetadataVisitor;
import java.io.IOException;

public abstract class AbstractMetadataElement {
    private final RecordingStream stream;
    final MutableMetadataLookup metadataLookup;
    private String id = "-1";
    private String name = null;
    private String simpleName = null;
    private final MetadataElementKind kind;

    AbstractMetadataElement(RecordingStream stream, MetadataElementKind kind) throws IOException {
        this.stream = stream;
        this.kind = kind;
        this.metadataLookup = (MutableMetadataLookup)stream.getContext().getMetadataLookup();
        this.processAttributes();
    }

    protected final void readSubelements(MetadataEvent event) throws IOException {
        int elemCount = (int)this.stream.readVarint();
        for (int i = 0; i < elemCount; ++i) {
            this.onSubelement(elemCount, event.readElement(this.stream));
        }
    }

    protected void onSubelement(int count, AbstractMetadataElement element) {
    }

    public abstract void accept(MetadataVisitor var1);

    protected void onAttribute(String key, String value) {
    }

    protected final void processAttributes() throws IOException {
        int attrCount = (int)this.stream.readVarint();
        for (int i = 0; i < attrCount; ++i) {
            int kv = (int)this.stream.readVarint();
            String key = this.metadataLookup.getString(kv);
            int vv = (int)this.stream.readVarint();
            String value = this.metadataLookup.getString(vv);
            if ("id".equals(key)) {
                this.id = value;
            }
            if ("name".equals(key)) {
                this.name = value;
            }
            this.onAttribute(key, value);
        }
    }

    public long getId() {
        return ParsingUtils.parseLongSWAR(this.id);
    }

    public String getName() {
        return this.name;
    }

    public String getSimpleName() {
        if (this.simpleName == null) {
            int idx = this.name.lastIndexOf(46);
            this.simpleName = idx == -1 ? this.name : this.name.substring(idx + 1);
        }
        return this.simpleName;
    }

    public MetadataElementKind getKind() {
        return this.kind;
    }

    public ParserContext getContext() {
        return this.stream.getContext();
    }
}

