/*
 * Decompiled with CFR 0.152.
 */
package io.jafar.parser.internal_api.collections;

import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.LongFunction;

public final class LongObjectHashMap<V> {
    private static final long EMPTY_KEY = Long.MIN_VALUE;
    private static final long PHI_MIX = -7046029254386353131L;
    private long[] keys;
    private Object[] values;
    private int mask;
    private int size;
    private int threshold;

    public LongObjectHashMap() {
        this(16);
    }

    public LongObjectHashMap(int expectedSize) {
        int capacity = LongObjectHashMap.tableSizeFor(expectedSize);
        this.keys = new long[capacity];
        this.values = new Object[capacity];
        this.mask = capacity - 1;
        this.threshold = capacity * 3 >>> 2;
        Arrays.fill(this.keys, Long.MIN_VALUE);
    }

    public V get(long key) {
        assert (key != Long.MIN_VALUE) : "Long.MIN_VALUE is reserved as sentinel key";
        int idx = this.index(key);
        long k;
        while ((k = this.keys[idx]) != key) {
            if (k == Long.MIN_VALUE) {
                return null;
            }
            idx = idx + 1 & this.mask;
        }
        return (V)this.values[idx];
    }

    public void put(long key, V value) {
        assert (key != Long.MIN_VALUE) : "Long.MIN_VALUE is reserved as sentinel key";
        if (value == null) {
            throw new NullPointerException("null values not supported");
        }
        int idx = this.index(key);
        while (true) {
            long k;
            if ((k = this.keys[idx]) == Long.MIN_VALUE) {
                this.keys[idx] = key;
                this.values[idx] = value;
                if (++this.size >= this.threshold) {
                    this.rehash();
                }
                return;
            }
            if (k == key) {
                this.values[idx] = value;
                return;
            }
            idx = idx + 1 & this.mask;
        }
    }

    public boolean containsKey(long key) {
        assert (key != Long.MIN_VALUE) : "Long.MIN_VALUE is reserved as sentinel key";
        int idx = this.index(key);
        long k;
        while ((k = this.keys[idx]) != key) {
            if (k == Long.MIN_VALUE) {
                return false;
            }
            idx = idx + 1 & this.mask;
        }
        return true;
    }

    public V putIfAbsent(long key, V value) {
        assert (key != Long.MIN_VALUE) : "Long.MIN_VALUE is reserved as sentinel key";
        if (value == null) {
            throw new NullPointerException("null values not supported");
        }
        int idx = this.index(key);
        long k;
        while ((k = this.keys[idx]) != key) {
            if (k == Long.MIN_VALUE) {
                this.keys[idx] = key;
                this.values[idx] = value;
                if (++this.size >= this.threshold) {
                    this.rehash();
                }
                return null;
            }
            idx = idx + 1 & this.mask;
        }
        return (V)this.values[idx];
    }

    public V getOrDefault(long key, V defaultValue) {
        assert (key != Long.MIN_VALUE) : "Long.MIN_VALUE is reserved as sentinel key";
        int idx = this.index(key);
        long k;
        while ((k = this.keys[idx]) != key) {
            if (k == Long.MIN_VALUE) {
                return defaultValue;
            }
            idx = idx + 1 & this.mask;
        }
        return (V)this.values[idx];
    }

    public V computeIfAbsent(long key, LongFunction<V> mappingFunction) {
        assert (key != Long.MIN_VALUE) : "Long.MIN_VALUE is reserved as sentinel key";
        int idx = this.index(key);
        long k;
        while ((k = this.keys[idx]) != key) {
            if (k == Long.MIN_VALUE) {
                V val = mappingFunction.apply(key);
                if (val == null) {
                    return null;
                }
                this.keys[idx] = key;
                this.values[idx] = val;
                if (++this.size >= this.threshold) {
                    this.rehash();
                }
                return val;
            }
            idx = idx + 1 & this.mask;
        }
        return (V)this.values[idx];
    }

    public Collection<V> values() {
        return new AbstractCollection<V>(){

            @Override
            public Iterator<V> iterator() {
                return new Iterator<V>(){
                    private int idx = 0;
                    private int remaining;
                    {
                        this.remaining = LongObjectHashMap.this.size;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.remaining > 0;
                    }

                    @Override
                    public V next() {
                        if (this.remaining <= 0) {
                            throw new NoSuchElementException();
                        }
                        while (LongObjectHashMap.this.values[this.idx] == null) {
                            ++this.idx;
                        }
                        --this.remaining;
                        return LongObjectHashMap.this.values[this.idx++];
                    }
                };
            }

            @Override
            public int size() {
                return LongObjectHashMap.this.size;
            }
        };
    }

    public void clear() {
        if (this.size > 0) {
            Arrays.fill(this.keys, Long.MIN_VALUE);
            Arrays.fill(this.values, null);
            this.size = 0;
        }
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    private int index(long key) {
        return (int)(key * -7046029254386353131L >>> 64 - Integer.numberOfTrailingZeros(this.keys.length)) & this.mask;
    }

    private void rehash() {
        long[] oldKeys = this.keys;
        Object[] oldValues = this.values;
        int newCapacity = oldKeys.length << 1;
        this.keys = new long[newCapacity];
        this.values = new Object[newCapacity];
        this.mask = newCapacity - 1;
        this.threshold = newCapacity * 3 >>> 2;
        Arrays.fill(this.keys, Long.MIN_VALUE);
        this.size = 0;
        for (int i = 0; i < oldKeys.length; ++i) {
            if (oldKeys[i] == Long.MIN_VALUE) continue;
            this.put(oldKeys[i], oldValues[i]);
        }
    }

    private static int tableSizeFor(int expected) {
        int n = Math.max(4, expected + (expected >>> 1));
        n = Integer.highestOneBit(n - 1) << 1;
        return n;
    }
}

