/*
 * Decompiled with CFR 0.152.
 */
package io.jafar.parser.internal_api.collections;

import java.util.Arrays;

public final class IntGrowableArray {
    private int[] data;
    private int size;

    public IntGrowableArray(int initialCapacity) {
        this.data = new int[initialCapacity];
    }

    public void add(int value) {
        if (this.size == this.data.length) {
            this.data = Arrays.copyOf(this.data, Math.max(1, this.data.length << 1));
        }
        this.data[this.size++] = value;
    }

    public void set(int index, int value) {
        this.data[index] = value;
    }

    public int size() {
        return this.size;
    }

    public int[] toIntArray() {
        return Arrays.copyOf(this.data, this.size);
    }
}

