/*
 * Decompiled with CFR 0.152.
 */
package io.jafar.parser.internal_api;

import io.jafar.parser.api.ConstantPool;
import io.jafar.parser.api.ConstantPools;
import io.jafar.parser.internal_api.MutableConstantPool;
import io.jafar.parser.internal_api.RecordingStream;
import io.jafar.parser.internal_api.collections.LongObjectHashMap;
import java.util.stream.Stream;

public final class MutableConstantPools
implements ConstantPools {
    private final LongObjectHashMap<MutableConstantPool> poolMap = new LongObjectHashMap();
    private boolean ready = false;

    @Override
    public MutableConstantPool getConstantPool(long typeId) {
        return this.poolMap.get(typeId);
    }

    public MutableConstantPool addOrGetConstantPool(RecordingStream chunkStream, long typeId, int count) {
        MutableConstantPool p = this.poolMap.get(typeId);
        if (p == null) {
            p = new MutableConstantPool(chunkStream, typeId, count);
            this.poolMap.put(typeId, p);
        }
        return p;
    }

    @Override
    public boolean hasConstantPool(long typeId) {
        return this.poolMap.containsKey(typeId);
    }

    @Override
    public boolean isReady() {
        return this.ready;
    }

    @Override
    public void setReady() {
        this.ready = true;
    }

    @Override
    public Stream<? extends ConstantPool> pools() {
        return this.poolMap.values().stream();
    }
}

