/*
 * Decompiled with CFR 0.152.
 */
package io.jafar.parser.internal_api;

import io.jafar.parser.internal_api.DeserializerCache;
import io.jafar.parser.internal_api.metadata.MetadataFingerprint;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;

public final class GlobalHandlerCache {
    private static final GlobalHandlerCache INSTANCE = new GlobalHandlerCache();
    private static final int MAX_CACHE_SIZE = 1000;
    private final Map<MetadataFingerprint, CacheEntry> cache;
    private final ReentrantLock lock = new ReentrantLock();
    private final AtomicLong totalHits = new AtomicLong(0L);
    private final AtomicLong totalMisses = new AtomicLong(0L);
    private final AtomicLong totalEvictions = new AtomicLong(0L);

    private GlobalHandlerCache() {
        this.cache = new LinkedHashMap<MetadataFingerprint, CacheEntry>(16, 0.75f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<MetadataFingerprint, CacheEntry> eldest) {
                if (this.size() > 1000) {
                    GlobalHandlerCache.this.totalEvictions.incrementAndGet();
                    return true;
                }
                return false;
            }
        };
    }

    public static GlobalHandlerCache getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeserializerCache getOrCreateCache(MetadataFingerprint fingerprint) {
        this.lock.lock();
        try {
            CacheEntry entry = this.cache.get(fingerprint);
            if (entry != null) {
                entry.hits.incrementAndGet();
                entry.lastAccessTime.set(System.nanoTime());
                this.totalHits.incrementAndGet();
                DeserializerCache deserializerCache = entry.deserializerCache;
                return deserializerCache;
            }
            this.totalMisses.incrementAndGet();
            DeserializerCache.Impl newCache = new DeserializerCache.Impl();
            entry = new CacheEntry(newCache);
            this.cache.put(fingerprint, entry);
            DeserializerCache.Impl impl = newCache;
            return impl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public int size() {
        this.lock.lock();
        try {
            int n = this.cache.size();
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    public long getTotalHits() {
        return this.totalHits.get();
    }

    public long getTotalMisses() {
        return this.totalMisses.get();
    }

    public long getTotalEvictions() {
        return this.totalEvictions.get();
    }

    public double getHitRate() {
        long misses;
        long hits = this.totalHits.get();
        long total = hits + (misses = this.totalMisses.get());
        if (total == 0L) {
            return 0.0;
        }
        return (double)hits * 100.0 / (double)total;
    }

    public void clear() {
        this.lock.lock();
        try {
            this.cache.clear();
            this.totalHits.set(0L);
            this.totalMisses.set(0L);
            this.totalEvictions.set(0L);
        }
        finally {
            this.lock.unlock();
        }
    }

    private static final class CacheEntry {
        final DeserializerCache deserializerCache;
        final AtomicLong hits;
        final AtomicLong lastAccessTime;

        CacheEntry(DeserializerCache cache) {
            this.deserializerCache = cache;
            this.hits = new AtomicLong(0L);
            this.lastAccessTime = new AtomicLong(System.nanoTime());
        }
    }
}

