/*
 * Decompiled with CFR 0.152.
 */
package io.jafar.parser.internal_api;

import io.jafar.parser.AbstractEvent;
import io.jafar.parser.TypeFilter;
import io.jafar.parser.api.ParserContext;
import io.jafar.parser.internal_api.MutableConstantPool;
import io.jafar.parser.internal_api.MutableConstantPools;
import io.jafar.parser.internal_api.RecordingStream;
import io.jafar.parser.internal_api.metadata.MetadataClass;
import java.io.IOException;

public final class CheckpointEvent
extends AbstractEvent {
    public final long startTime;
    public final long duration;
    public final int nextOffsetDelta;
    public final boolean isFlush;
    private final RecordingStream stream;

    CheckpointEvent(RecordingStream stream) throws IOException {
        super(stream);
        this.stream = stream;
        int size = (int)stream.readVarint();
        if (size == 0) {
            throw new IOException("Unexpected event size. Should be > 0");
        }
        long typeId = stream.readVarint();
        if (typeId != 1L) {
            throw new IOException("Unexpected event type: " + typeId + " (should be 1)");
        }
        this.startTime = stream.readVarint();
        this.duration = stream.readVarint();
        this.nextOffsetDelta = (int)stream.readVarint();
        this.isFlush = stream.read() != 0;
    }

    void readConstantPools() throws IOException {
        ParserContext context = this.stream.getContext();
        TypeFilter typeFilter = context.get(TypeFilter.class);
        boolean skipAll = context.getConstantPools().isReady();
        long cpCount = this.stream.readVarint();
        for (long i = 0L; i < cpCount; ++i) {
            long typeId = 0L;
            while ((typeId = this.stream.readVarint()) == 0L) {
            }
            int count = (int)this.stream.readVarint();
            MetadataClass clz = context.getMetadataLookup().getClass(typeId);
            if (clz == null) {
                throw new IOException("Constant pool references unknown type ID: " + typeId);
            }
            boolean skip = skipAll || typeFilter != null && !typeFilter.test(clz);
            MutableConstantPool constantPool = skip ? null : ((MutableConstantPools)context.getConstantPools()).addOrGetConstantPool(this.stream, typeId, count);
            for (int j = 0; j < count; ++j) {
                long id = this.stream.readVarint();
                if (!skip && !constantPool.containsKey(id)) {
                    constantPool.addOffset(id, this.stream.position());
                }
                clz.skipDirect(this.stream);
            }
            continue;
        }
    }
}

