/*
 * Decompiled with CFR 0.152.
 */
package io.jafar.parser.impl;

import io.jafar.parser.api.JafarConfigurationException;
import io.jafar.parser.api.JafarIOException;
import io.jafar.parser.api.JfrType;

public final class ValidationUtils {
    private ValidationUtils() {
    }

    public static void validateJfrTypeHandler(Class<?> clazz) throws JafarConfigurationException {
        if (clazz == null) {
            throw new JafarConfigurationException("JFR type handler class cannot be null");
        }
        if (clazz.isPrimitive() || String.class.equals(clazz)) {
            return;
        }
        if (!clazz.isInterface()) {
            throw JafarConfigurationException.invalidInterface(clazz);
        }
        JfrType typeAnnotation = clazz.getAnnotation(JfrType.class);
        if (typeAnnotation == null) {
            throw JafarConfigurationException.missingAnnotation(clazz, "JfrType");
        }
        if (typeAnnotation.value() == null || typeAnnotation.value().trim().isEmpty()) {
            throw new JafarConfigurationException("JfrType annotation value cannot be empty", clazz.getName());
        }
    }

    public static void validateParserNotClosed(boolean closed) throws JafarIOException {
        if (closed) {
            throw JafarIOException.parserClosed();
        }
    }

    public static void requireNonNull(Object value, String parameterName) throws JafarConfigurationException {
        if (value == null) {
            throw new JafarConfigurationException(String.format("Required parameter '%s' cannot be null", parameterName));
        }
    }

    public static void requireNonEmpty(String value, String parameterName) throws JafarConfigurationException {
        if (value == null || value.trim().isEmpty()) {
            throw new JafarConfigurationException(String.format("Required parameter '%s' cannot be null or empty", parameterName));
        }
    }
}

