/*
 * Decompiled with CFR 0.152.
 */
package io.jafar.parser.impl;

import io.jafar.parser.api.Control;
import io.jafar.parser.api.HandlerRegistration;
import io.jafar.parser.api.JafarParser;
import io.jafar.parser.api.ParsingContext;
import io.jafar.parser.api.UntypedJafarParser;
import io.jafar.parser.api.UntypedStrategy;
import io.jafar.parser.impl.EventStream;
import io.jafar.parser.impl.ParsingContextImpl;
import io.jafar.parser.internal_api.ChunkParserListener;
import io.jafar.parser.internal_api.StreamingChunkParser;
import io.jafar.parser.internal_api.metadata.MetadataClass;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class UntypedJafarParserImpl
implements UntypedJafarParser {
    private final ChunkParserListener parserListener;
    private final Path path;
    private final ParsingContext context;
    private final UntypedStrategy strategy;
    private final Set<UntypedJafarParser.EventHandler> handlers;

    public UntypedJafarParserImpl(Path path, ParsingContext context) {
        this(path, context, UntypedStrategy.SPARSE_ACCESS);
    }

    public UntypedJafarParserImpl(Path path, ParsingContext context, UntypedStrategy strategy) {
        this.path = path;
        this.context = context;
        this.strategy = strategy != null ? strategy : UntypedStrategy.SPARSE_ACCESS;
        this.handlers = new HashSet<UntypedJafarParser.EventHandler>();
        this.parserListener = null;
    }

    private UntypedJafarParserImpl(UntypedJafarParserImpl other, ChunkParserListener listener) {
        this.path = other.path;
        this.context = other.context;
        this.strategy = other.strategy;
        this.handlers = new HashSet<UntypedJafarParser.EventHandler>(other.handlers);
        this.parserListener = listener;
    }

    @Override
    public HandlerRegistration<?> handle(UntypedJafarParser.EventHandler handler) {
        this.handlers.add(handler);
        return new HandlerRegistrationImpl(handler);
    }

    @Override
    public void run() throws IOException {
        try (StreamingChunkParser parser = new StreamingChunkParser(((ParsingContextImpl)this.context).untypedContextFactory(this.strategy));){
            EventStream listener = new EventStream(this.parserListener){

                @Override
                protected void onEventValue(MetadataClass type, Map<String, Object> value, Control ctl) {
                    UntypedJafarParserImpl.this.handlers.forEach(h -> h.handle(type, value, ctl));
                }
            };
            parser.parse(this.path, (ChunkParserListener)listener);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public void close() throws Exception {
        this.handlers.clear();
    }

    public UntypedJafarParserImpl withParserListener(ChunkParserListener listener) {
        return new UntypedJafarParserImpl(this, listener);
    }

    private final class HandlerRegistrationImpl<T>
    implements HandlerRegistration<T> {
        private final UntypedJafarParser.EventHandler handler;

        HandlerRegistrationImpl(UntypedJafarParser.EventHandler handler) {
            this.handler = handler;
        }

        @Override
        public void destroy(JafarParser cookie) {
            assert (cookie == UntypedJafarParserImpl.this);
            UntypedJafarParserImpl.this.handlers.remove(this.handler);
        }
    }
}

