/*
 * Decompiled with CFR 0.152.
 */
package io.jafar.parser.impl;

import io.jafar.parser.api.Control;
import io.jafar.parser.api.HandlerFactory;
import io.jafar.parser.api.HandlerRegistration;
import io.jafar.parser.api.JFRHandler;
import io.jafar.parser.api.JafarConfigurationException;
import io.jafar.parser.api.JafarIOException;
import io.jafar.parser.api.JafarParser;
import io.jafar.parser.api.JfrIgnore;
import io.jafar.parser.api.JfrType;
import io.jafar.parser.api.ParserContext;
import io.jafar.parser.api.TypedJafarParser;
import io.jafar.parser.impl.ChunkInfoImpl;
import io.jafar.parser.impl.ControlImpl;
import io.jafar.parser.impl.ParsingContextImpl;
import io.jafar.parser.impl.TypedParserContext;
import io.jafar.parser.impl.ValidationUtils;
import io.jafar.parser.internal_api.CheckpointEvent;
import io.jafar.parser.internal_api.ChunkHeader;
import io.jafar.parser.internal_api.ChunkParserListener;
import io.jafar.parser.internal_api.RecordingStream;
import io.jafar.parser.internal_api.StreamingChunkParser;
import io.jafar.parser.internal_api.collections.IntObjectArrayMap;
import io.jafar.parser.internal_api.collections.LongObjectHashMap;
import io.jafar.parser.internal_api.metadata.MetadataClass;
import io.jafar.parser.internal_api.metadata.MetadataEvent;
import io.jafar.parser.internal_api.metadata.MetadataField;
import io.jafar.utils.CustomByteBuffer;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;

public final class TypedJafarParserImpl
implements TypedJafarParser {
    private final ChunkParserListener parserListener;
    private final StreamingChunkParser parser;
    private final Path recording;
    private final Map<Class<?>, Set<JFRHandler.Impl<?>>> handlerMap;
    private final IntObjectArrayMap<LongObjectHashMap<Class<?>>> chunkTypeClassMap;
    private final Map<String, Class<?>> globalHandlerMap;
    private final Map<Class<?>, HandlerFactory<?>> factoryMap;
    private volatile boolean factoriesBound = false;
    private boolean closed = false;

    public TypedJafarParserImpl(Path recording, ParsingContextImpl parsingContext) {
        this.parser = new StreamingChunkParser(parsingContext.typedContextFactory());
        this.recording = recording;
        this.handlerMap = new HashMap();
        this.chunkTypeClassMap = new IntObjectArrayMap();
        this.globalHandlerMap = new HashMap();
        this.factoryMap = new HashMap();
        this.parserListener = null;
        this.discoverFactories();
    }

    private TypedJafarParserImpl(TypedJafarParserImpl other, ChunkParserListener listener) {
        this.parser = other.parser;
        this.recording = other.recording;
        this.handlerMap = new HashMap(other.handlerMap);
        this.chunkTypeClassMap = new IntObjectArrayMap(other.chunkTypeClassMap);
        this.globalHandlerMap = new HashMap(other.globalHandlerMap);
        this.factoryMap = new HashMap(other.factoryMap);
        this.factoriesBound = false;
        this.closed = other.closed;
        this.parserListener = listener;
    }

    @Override
    public <T> HandlerRegistration<T> handle(Class<T> clz, JFRHandler<T> handler) {
        try {
            ValidationUtils.requireNonNull(clz, "clz");
            ValidationUtils.requireNonNull(handler, "handler");
            this.addDeserializer(clz);
            JFRHandler.Impl<T> handlerImpl = new JFRHandler.Impl<T>(clz, handler);
            this.handlerMap.computeIfAbsent(clz, k -> new HashSet()).add(handlerImpl);
            return new HandlerRegistrationImpl(clz, handlerImpl, this);
        }
        catch (JafarConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    private void addDeserializer(Class<?> clz) throws JafarConfigurationException {
        if (clz.isArray()) {
            clz = clz.getComponentType();
        }
        ValidationUtils.validateJfrTypeHandler(clz);
        boolean isPrimitive = clz.isPrimitive() || String.class.equals(clz);
        String typeName = clz.getName();
        if (!isPrimitive) {
            JfrType typeAnnotation = clz.getAnnotation(JfrType.class);
            typeName = typeAnnotation.value();
        }
        if (this.globalHandlerMap.containsKey(typeName)) {
            return;
        }
        this.globalHandlerMap.put(typeName, clz);
        if (!isPrimitive) {
            for (Method m : clz.getMethods()) {
                if (m.getAnnotation(JfrIgnore.class) != null) continue;
                this.addDeserializer(m.getReturnType());
            }
        }
    }

    @Override
    public void run() throws IOException {
        try {
            ValidationUtils.validateParserNotClosed(this.closed);
        }
        catch (JafarIOException e) {
            throw new IOException(e.getMessage(), e);
        }
        this.parser.parse(this.recording, new ChunkParserListener(){
            private final ThreadLocal<Control> control = ThreadLocal.withInitial(ControlImpl::new);
            private Set<String> referencedTypes = null;

            @Override
            public void onRecordingStart(ParserContext context) {
                if (TypedJafarParserImpl.this.parserListener != null) {
                    TypedJafarParserImpl.this.parserListener.onRecordingStart(context);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean onChunkStart(ParserContext context, int chunkIndex, ChunkHeader header) {
                if (!TypedJafarParserImpl.this.globalHandlerMap.isEmpty()) {
                    TypedParserContext lCtx = (TypedParserContext)context;
                    1 var5_5 = this;
                    synchronized (var5_5) {
                        lCtx.setClassTypeMap(TypedJafarParserImpl.this.chunkTypeClassMap.computeIfAbsent(chunkIndex, k -> new LongObjectHashMap()));
                        lCtx.addTargetTypeMap(TypedJafarParserImpl.this.globalHandlerMap);
                    }
                    context.put(Control.ChunkInfo.class, new ChunkInfoImpl(header));
                    ((ControlImpl)this.control.get()).setStream(context.get(RecordingStream.class));
                    return TypedJafarParserImpl.this.parserListener == null || TypedJafarParserImpl.this.parserListener.onChunkStart(context, chunkIndex, header);
                }
                return TypedJafarParserImpl.this.parserListener != null && TypedJafarParserImpl.this.parserListener.onChunkStart(context, chunkIndex, header);
            }

            @Override
            public boolean onChunkEnd(ParserContext context, int chunkIndex, boolean skipped) {
                ((ControlImpl)this.control.get()).setStream(null);
                return TypedJafarParserImpl.this.parserListener == null || TypedJafarParserImpl.this.parserListener.onChunkEnd(context, chunkIndex, skipped);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean onMetadata(ParserContext context, MetadataEvent metadata) {
                if (!(context instanceof TypedParserContext)) {
                    throw new RuntimeException("Invalid context");
                }
                TypedParserContext lContext = (TypedParserContext)context;
                LongObjectHashMap<Class<?>> typeClassMap = lContext.getClassTypeMap();
                if (!TypedJafarParserImpl.this.factoryMap.isEmpty() && !TypedJafarParserImpl.this.factoriesBound) {
                    TypedJafarParserImpl typedJafarParserImpl = TypedJafarParserImpl.this;
                    synchronized (typedJafarParserImpl) {
                        if (!TypedJafarParserImpl.this.factoriesBound) {
                            for (HandlerFactory handlerFactory : TypedJafarParserImpl.this.factoryMap.values()) {
                                handlerFactory.bind(context.getMetadataLookup());
                            }
                            for (Map.Entry entry : TypedJafarParserImpl.this.factoryMap.entrySet()) {
                                String jfrTypeName = ((HandlerFactory)entry.getValue()).getJfrTypeName();
                                MetadataClass metadataClass = context.getMetadataLookup().getClass(jfrTypeName);
                                if (metadataClass == null) continue;
                                metadataClass.bindFactory((HandlerFactory)entry.getValue());
                            }
                            TypedJafarParserImpl.this.factoriesBound = true;
                        }
                    }
                }
                if (!TypedJafarParserImpl.this.globalHandlerMap.isEmpty() && this.referencedTypes == null) {
                    this.referencedTypes = TypedJafarParserImpl.computeReferencedTypes(context, TypedJafarParserImpl.this.globalHandlerMap.keySet());
                    lContext.setTypeFilter(t -> t != null && this.referencedTypes.contains(t.getName()));
                }
                for (MetadataClass clz : metadata.getClasses()) {
                    Class<?> clazz = lContext.getClassTargetType(clz.getName());
                    if (clazz == null) continue;
                    typeClassMap.putIfAbsent(clz.getId(), clazz);
                }
                return TypedJafarParserImpl.this.parserListener == null || TypedJafarParserImpl.this.parserListener.onMetadata(context, metadata);
            }

            @Override
            public boolean onCheckpoint(ParserContext context, CheckpointEvent checkpoint) {
                if (TypedJafarParserImpl.this.parserListener != null) {
                    return TypedJafarParserImpl.this.parserListener.onCheckpoint(context, checkpoint);
                }
                return ChunkParserListener.super.onCheckpoint(context, checkpoint);
            }

            @Override
            public boolean onEvent(ParserContext context, long typeId, long eventStartPos, long rawSize, long payloadSize) {
                if (!(context instanceof TypedParserContext)) {
                    throw new RuntimeException("Invalid context");
                }
                TypedParserContext typedContext = (TypedParserContext)context;
                LongObjectHashMap<Class<?>> typeClassMap = typedContext.getClassTypeMap();
                Class<?> typeClz = typeClassMap.get(typeId);
                if (typeClz != null && TypedJafarParserImpl.this.handlerMap.containsKey(typeClz)) {
                    RecordingStream stream = context.get(RecordingStream.class);
                    MetadataClass clz = context.getMetadataLookup().getClass(typeId);
                    Object deserialized = clz.read(stream);
                    ControlImpl ctrl = (ControlImpl)this.control.get();
                    for (JFRHandler.Impl handler : (Set)TypedJafarParserImpl.this.handlerMap.get(typeClz)) {
                        handler.handle(deserialized, ctrl);
                        if (!ctrl.abortFlag) continue;
                        return false;
                    }
                }
                return TypedJafarParserImpl.this.parserListener == null || TypedJafarParserImpl.this.parserListener.onEvent(context, typeId, eventStartPos, rawSize, payloadSize);
            }
        });
    }

    @Override
    public void close() throws Exception {
        if (!this.closed) {
            this.closed = true;
            this.parser.close();
            this.chunkTypeClassMap.clear();
            this.handlerMap.clear();
            this.globalHandlerMap.clear();
            this.factoryMap.clear();
        }
    }

    private void discoverFactories() {
        try {
            ServiceLoader<HandlerFactory> loader = ServiceLoader.load(HandlerFactory.class);
            for (HandlerFactory factory : loader) {
                this.registerFactory(factory);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public <T> void registerFactory(HandlerFactory<T> factory) {
        if (factory == null) {
            throw new IllegalArgumentException("factory cannot be null");
        }
        Class<T> interfaceClass = factory.getInterfaceClass();
        this.factoryMap.put(interfaceClass, factory);
        String jfrTypeName = factory.getJfrTypeName();
        this.globalHandlerMap.put(jfrTypeName, interfaceClass);
    }

    public TypedJafarParserImpl withParserListener(ChunkParserListener listener) {
        return new TypedJafarParserImpl(this, listener);
    }

    private static Set<String> computeReferencedTypes(ParserContext context, Set<String> rootTypes) {
        HashSet<String> referencedTypes = new HashSet<String>();
        HashSet<String> toProcess = new HashSet<String>(rootTypes);
        while (!toProcess.isEmpty()) {
            String typeName = (String)toProcess.iterator().next();
            toProcess.remove(typeName);
            if (referencedTypes.contains(typeName)) continue;
            referencedTypes.add(typeName);
            MetadataClass metadataClass = context.getMetadataLookup().getClass(typeName);
            if (metadataClass == null) continue;
            for (MetadataField field : metadataClass.getFields()) {
                String fieldTypeName;
                MetadataClass fieldType = field.getType();
                if (fieldType == null || (fieldTypeName = fieldType.getName()) == null || referencedTypes.contains(fieldTypeName)) continue;
                toProcess.add(fieldTypeName);
            }
        }
        return referencedTypes;
    }

    private static CustomByteBuffer openJfrStream(Path jfrFile) {
        try {
            return CustomByteBuffer.map(jfrFile, Integer.MAX_VALUE);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private final class HandlerRegistrationImpl<T>
    implements HandlerRegistration<T> {
        private final WeakReference<Class<?>> clzRef;
        private final WeakReference<TypedJafarParser> cookieRef;
        private final JFRHandler.Impl<?> handler;

        HandlerRegistrationImpl(Class<?> clz, JFRHandler.Impl<?> handler, TypedJafarParser cookie) {
            this.clzRef = new WeakReference(clz);
            this.handler = handler;
            this.cookieRef = new WeakReference<TypedJafarParser>(cookie);
        }

        @Override
        public void destroy(JafarParser cookie) {
            Class clz;
            if (cookie != null && cookie.equals(this.cookieRef.get()) && (clz = (Class)this.clzRef.get()) != null) {
                Set handlers = (Set)TypedJafarParserImpl.this.handlerMap.get(clz);
                handlers.remove(this.handler);
                if (handlers.isEmpty()) {
                    TypedJafarParserImpl.this.handlerMap.remove(clz);
                }
            }
        }
    }
}

