/*
 * Decompiled with CFR 0.152.
 */
package io.jafar.parser.impl;

import io.jafar.parser.impl.LazyMapValueBuilder;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public final class LazyEventMap
extends AbstractMap<String, Object> {
    private final LazyMapValueBuilder.ArrayPool pool;
    private final int size;
    private String[] keys;
    private Object[] values;
    private Map<String, Object> materializedMap;

    public LazyEventMap(LazyMapValueBuilder.ArrayPool pool, int size) {
        this.pool = pool;
        this.size = size;
    }

    private void ensureArrays() {
        if (this.keys == null) {
            this.keys = this.pool.getKeys();
            this.values = this.pool.getValues();
        }
    }

    @Override
    public Object get(Object key) {
        if (this.materializedMap != null) {
            return this.materializedMap.get(key);
        }
        this.ensureArrays();
        for (int i = 0; i < this.size; ++i) {
            if (!this.keys[i].equals(key)) continue;
            return this.values[i];
        }
        return null;
    }

    @Override
    public boolean containsKey(Object key) {
        if (this.materializedMap != null) {
            return this.materializedMap.containsKey(key);
        }
        this.ensureArrays();
        for (int i = 0; i < this.size; ++i) {
            if (!this.keys[i].equals(key)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        this.materialize();
        return this.materializedMap.entrySet();
    }

    @Override
    public Set<String> keySet() {
        if (this.materializedMap != null) {
            return this.materializedMap.keySet();
        }
        this.ensureArrays();
        return new AbstractSet<String>(){

            @Override
            public Iterator<String> iterator() {
                return Arrays.asList(Arrays.copyOf(LazyEventMap.this.keys, LazyEventMap.this.size)).iterator();
            }

            @Override
            public int size() {
                return LazyEventMap.this.size;
            }

            @Override
            public boolean contains(Object o) {
                return LazyEventMap.this.containsKey(o);
            }
        };
    }

    private void materialize() {
        if (this.materializedMap == null) {
            this.ensureArrays();
            this.materializedMap = new HashMap<String, Object>(this.size);
            for (int i = 0; i < this.size; ++i) {
                this.materializedMap.put(this.keys[i], this.values[i]);
            }
        }
    }
}

