/*
 * Decompiled with CFR 0.152.
 */
package io.jafar.parser.api;

import io.jafar.parser.api.JafarRecordedEvent;
import io.jafar.parser.api.ParsingContext;
import io.jafar.parser.api.UntypedStrategy;
import io.jafar.parser.impl.EventIteratorImpl;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.NoSuchElementException;

public interface EventIterator
extends Iterator<JafarRecordedEvent>,
AutoCloseable {
    public static EventIterator open(Path path) throws IOException {
        return EventIterator.open(path, ParsingContext.create());
    }

    public static EventIterator open(Path path, ParsingContext context) throws IOException {
        return EventIterator.open(path, context, 1000);
    }

    public static EventIterator open(Path path, ParsingContext context, int bufferSize) throws IOException {
        return EventIterator.open(path, context, bufferSize, UntypedStrategy.SPARSE_ACCESS);
    }

    public static EventIterator open(Path path, ParsingContext context, int bufferSize, UntypedStrategy strategy) throws IOException {
        if (bufferSize < 1) {
            throw new IllegalArgumentException("Buffer size must be at least 1");
        }
        return new EventIteratorImpl(path, context, bufferSize, strategy);
    }

    @Override
    public boolean hasNext();

    @Override
    public JafarRecordedEvent next() throws NoSuchElementException;

    public IOException getParsingError();

    @Override
    public void close() throws IOException;
}

