/*
 * Decompiled with CFR 0.152.
 */
package io.jafar.parser;

import io.jafar.parser.api.ConstantPool;
import io.jafar.parser.api.ConstantPools;
import io.jafar.parser.internal_api.RecordingStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;

public final class ParsingUtils {
    private static final long POW10_8 = 100000000L;

    public static String bytesToString(byte[] array, int offset, int len) {
        StringBuilder sb = new StringBuilder("[");
        boolean comma = false;
        for (int i = 0; i < len; ++i) {
            if (comma) {
                sb.append(", ");
            } else {
                comma = true;
            }
            sb.append(array[i + offset]);
        }
        sb.append(']');
        return sb.toString();
    }

    public static String readUTF8(RecordingStream stream, long stringTypeId) throws IOException {
        byte id = stream.read();
        if (id == 0) {
            return null;
        }
        if (id == 1) {
            return "";
        }
        if (id == 2) {
            Object value;
            ConstantPool stringPool;
            int ptr = (int)stream.readVarint();
            ConstantPools constantPools = stream.getContext().getConstantPools();
            if (stringTypeId == -1L) {
                return stream.getContext().getMetadataLookup().getString(ptr);
            }
            if (constantPools != null && (stringPool = constantPools.getConstantPool(stringTypeId)) != null && (value = stringPool.get(ptr)) instanceof String) {
                return (String)value;
            }
            return null;
        }
        if (id == 3) {
            int size = (int)stream.readVarint();
            if (size == 0) {
                return "";
            }
            byte[] content = size <= stream.getContext().byteBuffer.length ? stream.getContext().byteBuffer : new byte[size];
            stream.read(content, 0, size);
            return stream.getContext().utf8Parser.parse(content, size, StandardCharsets.UTF_8);
        }
        if (id == 4) {
            int size = (int)stream.readVarint();
            if (size == 0) {
                return "";
            }
            char[] chars = size <= stream.getContext().charBuffer.length ? stream.getContext().charBuffer : new char[size];
            for (int i = 0; i < size; ++i) {
                chars[i] = (char)stream.readVarint();
            }
            return stream.getContext().charParser.parse(chars, size);
        }
        if (id == 5) {
            int size = (int)stream.readVarint();
            if (size == 0) {
                return "";
            }
            byte[] content = size <= stream.getContext().byteBuffer.length ? stream.getContext().byteBuffer : new byte[size];
            stream.read(content, 0, size);
            return stream.getContext().utf8Parser.parse(content, size, StandardCharsets.ISO_8859_1);
        }
        throw new IOException("Unexpected string constant id: " + id);
    }

    public static void skipUTF8(RecordingStream stream) throws IOException {
        byte id = stream.read();
        switch (id) {
            case 3: 
            case 5: {
                int size = (int)stream.readVarint();
                stream.skip(size);
                break;
            }
            case 4: {
                int size = (int)stream.readVarint();
                for (int i = 0; i < size; ++i) {
                    stream.readVarint();
                }
                break;
            }
            case 2: {
                stream.readVarint();
                break;
            }
        }
    }

    public static long parseLongSWAR(CharSequence s) {
        int n = s.length();
        if (n == 0) {
            throw ParsingUtils.nfe(s);
        }
        int i = 0;
        boolean neg = false;
        char c0 = s.charAt(0);
        if (c0 == '+' || c0 == '-') {
            boolean bl = neg = c0 == '-';
            if (++i == n) {
                throw ParsingUtils.nfe(s);
            }
        }
        while (i < n && s.charAt(i) == '0') {
            ++i;
        }
        int start = i;
        int digits = n - start;
        if (digits == 0) {
            return 0L;
        }
        if (digits > 19) {
            throw ParsingUtils.nfe(s);
        }
        long acc = 0L;
        while (digits >= 8) {
            long limit;
            long block = ParsingUtils.parse8(s, i);
            long l = limit = neg ? 92233720368L : 92233720368L;
            if (acc > limit) {
                throw ParsingUtils.nfe(s);
            }
            acc *= 100000000L;
            if (neg) {
                if (acc < Long.MIN_VALUE + block) {
                    throw ParsingUtils.nfe(s);
                }
                acc -= block;
            } else {
                if (block > Long.MAX_VALUE - acc) {
                    throw ParsingUtils.nfe(s);
                }
                acc += block;
            }
            digits -= 8;
            i += 8;
        }
        while (digits-- > 0) {
            long lim;
            int d;
            if (((d = s.charAt(i++) - 48) | 9 - d) < 0) {
                throw ParsingUtils.nfe(s);
            }
            long l = lim = neg ? Long.MIN_VALUE : Long.MAX_VALUE;
            if (!neg) {
                if (acc > (Long.MAX_VALUE - (long)d) / 10L) {
                    throw ParsingUtils.nfe(s);
                }
                acc = acc * 10L + (long)d;
                continue;
            }
            if (acc < (Long.MIN_VALUE + (long)d) / 10L) {
                throw ParsingUtils.nfe(s);
            }
            acc = acc * 10L - (long)d;
        }
        return acc;
    }

    private static long parse8(CharSequence s, int off) {
        long v7;
        long v6;
        long v5;
        long v4;
        long v3;
        long v2;
        long v1;
        long v0 = s.charAt(off) - 48;
        if ((v0 | 9L - v0) < 0L | ((v1 = (long)(s.charAt(off + 1) - 48)) | 9L - v1) < 0L | ((v2 = (long)(s.charAt(off + 2) - 48)) | 9L - v2) < 0L | ((v3 = (long)(s.charAt(off + 3) - 48)) | 9L - v3) < 0L | ((v4 = (long)(s.charAt(off + 4) - 48)) | 9L - v4) < 0L | ((v5 = (long)(s.charAt(off + 5) - 48)) | 9L - v5) < 0L | ((v6 = (long)(s.charAt(off + 6) - 48)) | 9L - v6) < 0L | ((v7 = (long)(s.charAt(off + 7) - 48)) | 9L - v7) < 0L) {
            throw ParsingUtils.nfe(null);
        }
        return ((((((v0 * 10L + v1) * 10L + v2) * 10L + v3) * 10L + v4) * 10L + v5) * 10L + v6) * 10L + v7;
    }

    private static NumberFormatException nfe(CharSequence s) {
        return new NumberFormatException(s == null ? "invalid digits" : "For input: \"" + s + '\"');
    }
}

