/*
 * Decompiled with CFR 0.152.
 */
package io.jafar.parser.api;

import io.jafar.parser.api.ArrayType;
import io.jafar.parser.api.ComplexType;
import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class Values {
    private Values() {
    }

    public static Object get(Map<String, Object> root, Object ... path) {
        Objects.requireNonNull(root, "root");
        Object current = root;
        if (path == null || path.length == 0) {
            return current;
        }
        for (Object segment : path) {
            if (current instanceof ComplexType) {
                ComplexType complex = (ComplexType)current;
                current = complex.getValue();
            }
            if (segment instanceof CharSequence) {
                String key = segment.toString();
                if (current instanceof Map) {
                    Map<String, Object> map = current;
                    current = map.get(key);
                    continue;
                }
                return null;
            }
            if (segment instanceof Integer) {
                Integer idx = (Integer)segment;
                Object array = Values.unwrapArray(current);
                if (array == null) {
                    return null;
                }
                int length = Array.getLength(array);
                if (idx < 0 || idx >= length) {
                    return null;
                }
                current = Array.get(array, idx);
                continue;
            }
            throw new IllegalArgumentException("Unsupported path segment type: " + String.valueOf(segment));
        }
        return Values.unwrapArray(Values.unwrapComplex(current));
    }

    public static <T> Optional<T> as(Map<String, Object> root, Class<T> type, Object ... path) {
        Object value = Values.get(root, path);
        return type.isInstance(value) ? Optional.of(type.cast(value)) : Optional.empty();
    }

    public static Map<String, Object> resolvedShallow(Map<String, Object> root) {
        HashMap<String, Object> out = new HashMap<String, Object>(root.size());
        for (Map.Entry<String, Object> e : root.entrySet()) {
            Map<String, Object> v = e.getValue();
            if (v instanceof ComplexType) {
                ComplexType c = (ComplexType)((Object)v);
                v = c.getValue();
            }
            v = Values.unwrapArray(v);
            out.put(e.getKey(), v);
        }
        return out;
    }

    public static Map<String, Object> resolvedDeep(Map<String, Object> root) {
        HashMap<String, Object> out = new HashMap<String, Object>(root.size());
        for (Map.Entry<String, Object> e : root.entrySet()) {
            Object v = e.getValue();
            v = Values.resolveDeepValue(v);
            out.put(e.getKey(), v);
        }
        return out;
    }

    private static Object resolveDeepValue(Object v) {
        if (v instanceof ComplexType) {
            ComplexType c = (ComplexType)v;
            return Values.resolvedDeep(c.getValue());
        }
        Object array = Values.unwrapArray(v);
        if (array != null && array.getClass().isArray()) {
            Class<?> componentType = array.getClass().getComponentType();
            if (componentType.isPrimitive()) {
                return array;
            }
            Object[] in = (Object[])array;
            Object[] out = new Object[in.length];
            for (int i = 0; i < in.length; ++i) {
                out[i] = Values.resolveDeepValue(in[i]);
            }
            return out;
        }
        if (v instanceof Map) {
            Map m = (Map)v;
            HashMap<String, Object> res = new HashMap<String, Object>(m.size());
            for (Map.Entry me : m.entrySet()) {
                res.put(String.valueOf(me.getKey()), Values.resolveDeepValue(me.getValue()));
            }
            return res;
        }
        return v;
    }

    private static Object unwrapArray(Object value) {
        if (value instanceof ArrayType) {
            ArrayType at = (ArrayType)value;
            return at.getArray();
        }
        return value;
    }

    private static Object unwrapComplex(Object value) {
        if (value instanceof ComplexType) {
            ComplexType ct = (ComplexType)value;
            return ct.getValue();
        }
        return value;
    }
}

